/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.TypeReference;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LazyInitializedComponentDefinition;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;
import org.axonframework.queryhandling.QueryMessage;

@Internal
public class DefaultDispatchInterceptorRegistry
implements DispatchInterceptorRegistry {
    private static final TypeReference<MessageDispatchInterceptor<Message>> INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<Message>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super CommandMessage>> COMMAND_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super CommandMessage>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super EventMessage>> EVENT_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super EventMessage>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super QueryMessage>> QUERY_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super QueryMessage>>(){};
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>>> commandInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>>>();
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>>> eventInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>>>();
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>>> queryInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>>>();

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<Message>> interceptorBuilder) {
        GenericInterceptorDefinition genericInterceptorDef = new GenericInterceptorDefinition(interceptorBuilder);
        this.registerCommandInterceptor(config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((CommandMessage)m, c));
        });
        this.registerEventInterceptor(config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((EventMessage)m, c));
        });
        this.registerQueryInterceptor(config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((QueryMessage)m, c));
        });
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerCommandInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.commandInterceptorDefinitions.add(ComponentDefinition.ofType(COMMAND_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerEventInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>> interceptorBuilder) {
        this.eventInterceptorDefinitions.add(ComponentDefinition.ofType(EVENT_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerQueryInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.queryInterceptorDefinitions.add(ComponentDefinition.ofType(QUERY_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super CommandMessage>> commandInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super CommandMessage>>();
        for (ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>> interceptorBuilder : this.commandInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageDispatchInterceptor dispatchInterceptor = (MessageDispatchInterceptor)creator.createComponent().resolve(config);
            dispatchInterceptors.add(dispatchInterceptor);
        }
        return dispatchInterceptors;
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super EventMessage>> eventInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageDispatchInterceptor<? super EventMessage>> dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super EventMessage>>();
        for (ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>> interceptorBuilder : this.eventInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageDispatchInterceptor dispatchInterceptor = (MessageDispatchInterceptor)creator.createComponent().resolve(config);
            dispatchInterceptors.add(dispatchInterceptor);
        }
        return dispatchInterceptors;
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super QueryMessage>> queryInterceptors(@Nonnull Configuration config) {
        ArrayList<MessageDispatchInterceptor<? super QueryMessage>> dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super QueryMessage>>();
        for (ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>> interceptorBuilder : this.queryInterceptorDefinitions) {
            if (!(interceptorBuilder instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(interceptorBuilder));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)interceptorBuilder;
            MessageDispatchInterceptor dispatchInterceptor = (MessageDispatchInterceptor)creator.createComponent().resolve(config);
            dispatchInterceptors.add(dispatchInterceptor);
        }
        return dispatchInterceptors;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandDispatchInterceptors", this.commandInterceptorDefinitions);
        descriptor.describeProperty("eventDispatchInterceptors", this.eventInterceptorDefinitions);
        descriptor.describeProperty("queryDispatchInterceptors", this.queryInterceptorDefinitions);
    }

    private static class GenericInterceptorDefinition
    extends LazyInitializedComponentDefinition<MessageDispatchInterceptor<Message>, MessageDispatchInterceptor<Message>> {
        public GenericInterceptorDefinition(ComponentBuilder<MessageDispatchInterceptor<Message>> builder) {
            super(new Component.Identifier<MessageDispatchInterceptor<Message>>(INTERCEPTOR_TYPE_REF, null), builder);
        }
    }
}

