/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.interceptors.annotations.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.interceptors.annotations.NoMoreInterceptors;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ChainedMessageHandlerInterceptorMember<T>
implements MessageHandlerInterceptorMemberChain<T> {
    private final MessageHandlingMember<? super T> delegate;
    private final MessageHandlerInterceptorMemberChain<T> next;

    public ChainedMessageHandlerInterceptorMember(Class<?> handlerType, Iterator<MessageHandlingMember<? super T>> iterator) {
        this.delegate = iterator.next();
        this.next = iterator.hasNext() ? new ChainedMessageHandlerInterceptorMember<T>(handlerType, iterator) : NoMoreInterceptors.instance();
    }

    @Override
    public MessageStream<?> handle(@Nonnull Message message, @Nonnull ProcessingContext context, @Nonnull T target, @Nonnull MessageHandlingMember<? super T> handler) {
        return this.doHandle(message, context, target, handler);
    }

    private MessageStream<?> doHandle(Message message, ProcessingContext context, T target, MessageHandlingMember<? super T> handler) {
        return this.delegate.canHandle(message, context) ? this.delegate.handle(message, context, target) : this.next.handle(message, context, (T)target, handler);
    }

    @Override
    public Object handleSync(@Nonnull Message message, @Nonnull ProcessingContext context, @Nonnull T target, @Nonnull MessageHandlingMember<? super T> handler) throws Exception {
        return this.doHandleSync(message, context, target, handler);
    }

    private Object doHandleSync(Message message, ProcessingContext context, T target, MessageHandlingMember<? super T> handler) throws Exception {
        return this.delegate.canHandle(message, context) ? this.delegate.handleSync(message, context, target) : this.next.handleSync(message, context, (T)target, handler);
    }
}

