/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tracing;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.tracing.EventProcessorSpanFactory;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultEventProcessorSpanFactory
implements EventProcessorSpanFactory {
    private final SpanFactory spanFactory;
    private final boolean disableBatchTrace;
    private final boolean distributedInSameTrace;
    private final Duration distributedInSameTraceTimeLimit;

    protected DefaultEventProcessorSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.disableBatchTrace = builder.builderDisableBatchTrace;
        this.distributedInSameTrace = builder.builderDistributedInSameTrace;
        this.distributedInSameTraceTimeLimit = builder.builderDistributedInSameTraceTimeLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Span createBatchSpan(boolean streaming, List<? extends EventMessage> eventMessages) {
        if (this.distributedInSameTrace || this.disableBatchTrace || !streaming) {
            return NoOpSpanFactory.NoOpSpan.INSTANCE;
        }
        return this.spanFactory.createRootTrace(() -> "StreamingEventProcessor.batch");
    }

    @Override
    public Span createProcessEventSpan(boolean streaming, EventMessage eventMessage) {
        if (!streaming) {
            return this.spanFactory.createChildHandlerSpan(() -> "EventProcessor.process", eventMessage, new Message[0]);
        }
        Supplier<String> name = () -> "StreamingEventProcessor.process";
        if (this.distributedInSameTrace && eventMessage.timestamp().isAfter(Instant.now().minus(this.distributedInSameTraceTimeLimit))) {
            return this.spanFactory.createChildHandlerSpan(name, eventMessage, new Message[0]);
        }
        if (this.disableBatchTrace) {
            return this.spanFactory.createLinkedHandlerSpan(name, eventMessage, new Message[0]);
        }
        return this.spanFactory.createChildHandlerSpan(name, eventMessage, new Message[0]);
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private boolean builderDisableBatchTrace;
        private boolean builderDistributedInSameTrace;
        private Duration builderDistributedInSameTraceTimeLimit = Duration.ofMinutes(2L);

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder disableBatchTrace(boolean disableBatchTrace) {
            this.builderDisableBatchTrace = disableBatchTrace;
            return this;
        }

        public Builder distributedInSameTrace(boolean distributedInSameTrace) {
            this.builderDistributedInSameTrace = distributedInSameTrace;
            return this;
        }

        public Builder distributedInSameTraceTimeLimit(Duration distributedInSameTraceTimeLimit) {
            BuilderUtils.assertNonNull(this.builderSpanFactory, "distributedInSameTraceTimeLimit may not be null");
            this.builderDistributedInSameTraceTimeLimit = distributedInSameTraceTimeLimit;
            return this;
        }

        protected void validate() {
            if (this.builderDistributedInSameTrace) {
                BuilderUtils.assertNonNull(this.builderDistributedInSameTraceTimeLimit, "distributedInSameTraceTimeLimit may not be null");
            }
            BuilderUtils.assertNonNull(this.builderSpanFactory, "spanFactory may not be null");
        }

        public DefaultEventProcessorSpanFactory build() {
            return new DefaultEventProcessorSpanFactory(this);
        }
    }
}

