/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.token.ReplayToken;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventhandling.replay.ReplayStatus;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayParameterResolverFactory
implements ParameterResolverFactory {
    @Nullable
    public ParameterResolver<ReplayStatus> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (ReplayStatus.class.isAssignableFrom(parameters[parameterIndex].getType())) {
            return new ReplayParameterResolver();
        }
        return null;
    }

    private static class ReplayParameterResolver
    implements ParameterResolver<ReplayStatus> {
        private ReplayParameterResolver() {
        }

        @Override
        @Nullable
        public ReplayStatus resolveParameterValue(@Nonnull ProcessingContext context) {
            Optional<TrackingToken> optionalToken = TrackingToken.fromContext(context);
            if (Message.fromContext(context) instanceof EventMessage && optionalToken.isPresent()) {
                return ReplayToken.isReplay(optionalToken.get()) ? ReplayStatus.REPLAY : ReplayStatus.REGULAR;
            }
            return ReplayStatus.REGULAR;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

