/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.segmenting;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.DelegatingEventHandlingComponent;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SequencingEventHandlingComponent
extends DelegatingEventHandlingComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Context.ResourceKey<Map<Object, CompletableFuture<?>>> sequencedInvocationsKey = Context.ResourceKey.withLabel("sequencedInvocations");

    public SequencingEventHandlingComponent(@Nonnull EventHandlingComponent delegate) {
        super(delegate);
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(event, "Event may not be null");
        Objects.requireNonNull(context, "ProcessingContext may not be null");
        Map invocationsBySequenceIdentifier = context.computeResourceIfAbsent(this.sequencedInvocationsKey, ConcurrentHashMap::new);
        CompletableFuture resultFuture = invocationsBySequenceIdentifier.compute(this.sequenceIdentifierFor(event, context), (sequenceIdentifier, previousInvocation) -> this.chainedSequenceInvocations(sequenceIdentifier, (CompletableFuture<?>)previousInvocation, event, context));
        return MessageStream.fromFuture(resultFuture).ignoreEntries();
    }

    private CompletableFuture<?> chainedSequenceInvocations(Object sequenceIdentifier, CompletableFuture<?> previousInvocation, EventMessage event, ProcessingContext context) {
        if (previousInvocation == null) {
            logger.debug("Event [{}] | No previous invocation for sequence identifier [{}]. Handling immediately.", (Object)event, sequenceIdentifier);
            return this.delegate.handle(event, context).asCompletableFuture();
        }
        logger.debug("Event [{}] | Previous invocation found for sequence identifier [{}]. Chaining the current event handling.", (Object)event, sequenceIdentifier);
        return previousInvocation.thenCompose(r -> this.delegate.handle(event, context).asCompletableFuture());
    }
}

