/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.pooled;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.axonframework.common.annotations.Internal;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.eventhandling.configuration.EventHandlingComponentsConfigurer;
import org.axonframework.eventhandling.configuration.EventProcessingConfigurer;
import org.axonframework.eventhandling.configuration.EventProcessorModule;
import org.axonframework.eventhandling.processors.streaming.pooled.PooledStreamingEventProcessorConfiguration;
import org.axonframework.eventhandling.processors.streaming.pooled.PooledStreamingEventProcessorModule;
import org.axonframework.eventhandling.processors.streaming.token.store.TokenStore;
import org.axonframework.eventhandling.processors.streaming.token.store.inmemory.InMemoryTokenStore;
import org.axonframework.eventstreaming.StreamableEventSource;

public class PooledStreamingEventProcessorsConfigurer {
    private final EventProcessingConfigurer parent;
    private PooledStreamingEventProcessorModule.Customization processorsDefaultCustomization = PooledStreamingEventProcessorModule.Customization.noOp();
    private final List<ModuleBuilder<PooledStreamingEventProcessorModule>> moduleBuilders = new ArrayList<ModuleBuilder<PooledStreamingEventProcessorModule>>();

    @Internal
    public PooledStreamingEventProcessorsConfigurer(@Nonnull EventProcessingConfigurer parent) {
        this.parent = parent;
    }

    @Internal
    public void build() {
        this.componentRegistry(cr -> cr.registerIfNotPresent(TokenStore.class, cfg -> new InMemoryTokenStore()));
        this.componentRegistry(cr -> cr.registerComponent(PooledStreamingEventProcessorModule.Customization.class, cfg -> PooledStreamingEventProcessorModule.Customization.noOp().andThen((axonConfig, processorConfig) -> {
            cfg.getOptionalComponent(TokenStore.class).ifPresent(processorConfig::tokenStore);
            cfg.getOptionalComponent(StreamableEventSource.class).ifPresent(processorConfig::eventSource);
            return processorConfig;
        }).andThen(this.processorsDefaultCustomization)));
        this.moduleBuilders.forEach(moduleBuilder -> this.componentRegistry(cr -> cr.registerModule((Module)moduleBuilder.build())));
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer defaults(@Nonnull BiFunction<Configuration, PooledStreamingEventProcessorConfiguration, PooledStreamingEventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults must not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen(configureDefaults::apply);
        return this;
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer defaults(@Nonnull UnaryOperator<PooledStreamingEventProcessorConfiguration> configureDefaults) {
        Objects.requireNonNull(configureDefaults, "configureDefaults must not be null");
        this.processorsDefaultCustomization = this.processorsDefaultCustomization.andThen((axonConfig, pConfig) -> (PooledStreamingEventProcessorConfiguration)configureDefaults.apply((PooledStreamingEventProcessorConfiguration)pConfig));
        return this;
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer defaultProcessor(@Nonnull String name, @Nonnull Function<EventHandlingComponentsConfigurer.RequiredComponentPhase, EventHandlingComponentsConfigurer.CompletePhase> eventHandlingComponentsBuilder) {
        this.processor(() -> EventProcessorModule.pooledStreaming(name).eventHandlingComponents(eventHandlingComponentsBuilder).notCustomized().build());
        return this;
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer processor(@Nonnull String name, @Nonnull Function<EventProcessorModule.EventHandlingPhase<PooledStreamingEventProcessorModule, PooledStreamingEventProcessorConfiguration>, PooledStreamingEventProcessorModule> moduleCustomizer) {
        this.processor(() -> ((PooledStreamingEventProcessorModule)moduleCustomizer.apply(EventProcessorModule.pooledStreaming(name))).build());
        return this;
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer processor(@Nonnull ModuleBuilder<PooledStreamingEventProcessorModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "moduleBuilder may not be null");
        this.moduleBuilders.add(moduleBuilder);
        return this;
    }

    @Nonnull
    public PooledStreamingEventProcessorsConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> registryAction) {
        Objects.requireNonNull(registryAction, "registryAction may not be null");
        this.parent.componentRegistry(registryAction);
        return this;
    }
}

