/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.annotations.AnnotatedEventHandlingComponent;
import org.axonframework.messaging.annotations.ParameterResolverFactory;

public interface EventHandlingComponentsConfigurer {

    public static interface CompletePhase {
        @Nonnull
        public CompletePhase decorated(@Nonnull BiFunction<Configuration, EventHandlingComponent, EventHandlingComponent> var1);

        @Nonnull
        public List<ComponentBuilder<EventHandlingComponent>> toList();

        @Nonnull
        default public List<EventHandlingComponent> build(Configuration configuration) {
            return this.toList().stream().map(builder -> (EventHandlingComponent)builder.build(configuration)).toList();
        }
    }

    public static interface ComponentsPhase<T> {
        @Nonnull
        public AdditionalComponentPhase declarative(@Nonnull ComponentBuilder<EventHandlingComponent> var1);

        @Nonnull
        default public AdditionalComponentPhase annotated(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.declarative(c -> new AnnotatedEventHandlingComponent(handlingComponentBuilder.build(c), c.getComponent(ParameterResolverFactory.class)));
        }
    }

    public static interface AdditionalComponentPhase
    extends ComponentsPhase<AdditionalComponentPhase>,
    CompletePhase {
    }

    public static interface RequiredComponentPhase
    extends ComponentsPhase<AdditionalComponentPhase> {
    }
}

