/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.annotations.SequencingPolicy;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.UnsupportedHandlerException;
import org.axonframework.messaging.annotations.WrappedMessageHandlingMember;

public class MethodSequencingPolicyEventHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.unwrap(Method.class).flatMap(method -> this.findSequencingPolicy((Method)method).map(annotation -> new SequencingPolicyEventMessageHandlingMember(original, (SequencingPolicy)annotation))).orElse(original);
    }

    private Optional<SequencingPolicy> findSequencingPolicy(Method method) {
        return Optional.ofNullable(method.getAnnotation(SequencingPolicy.class)).or(() -> Optional.ofNullable(method.getDeclaringClass().getAnnotation(SequencingPolicy.class)));
    }

    @Internal
    static class SequencingPolicyEventMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements MessageHandlingMember<T> {
        private final org.axonframework.eventhandling.sequencing.SequencingPolicy sequencingPolicy;

        private SequencingPolicyEventMessageHandlingMember(MessageHandlingMember<T> original, SequencingPolicy policyAnnotation) {
            super(original);
            this.sequencingPolicy = this.createSequencingPolicy(policyAnnotation, original);
        }

        public org.axonframework.eventhandling.sequencing.SequencingPolicy sequencingPolicy() {
            return this.sequencingPolicy;
        }

        private org.axonframework.eventhandling.sequencing.SequencingPolicy createSequencingPolicy(SequencingPolicy annotation, MessageHandlingMember<T> original) {
            Class<? extends org.axonframework.eventhandling.sequencing.SequencingPolicy> policyType = annotation.type();
            String[] parameters = annotation.parameters();
            try {
                return parameters.length == 0 ? this.createNoArgPolicy(policyType, original) : this.createParameterizedPolicy(policyType, parameters, original);
            }
            catch (Exception e) {
                throw new UnsupportedHandlerException("Failed to create SequencingPolicy instance: " + e.getMessage(), original.unwrap(Member.class).orElse(null));
            }
        }

        private org.axonframework.eventhandling.sequencing.SequencingPolicy createNoArgPolicy(Class<? extends org.axonframework.eventhandling.sequencing.SequencingPolicy> policyType, MessageHandlingMember<T> original) throws Exception {
            try {
                Constructor<? extends org.axonframework.eventhandling.sequencing.SequencingPolicy> constructor = policyType.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedHandlerException("SequencingPolicy " + policyType.getName() + " must have a no-arg constructor", original.unwrap(Member.class).orElse(null));
            }
        }

        private org.axonframework.eventhandling.sequencing.SequencingPolicy createParameterizedPolicy(Class<? extends org.axonframework.eventhandling.sequencing.SequencingPolicy> policyType, String[] parameters, MessageHandlingMember<T> original) throws Exception {
            Constructor<?> matchingConstructor = this.findMatchingConstructor(policyType, parameters.length, original);
            Object[] parsedParameters = this.parseParameters(matchingConstructor.getParameterTypes(), parameters, original);
            matchingConstructor.setAccessible(true);
            return (org.axonframework.eventhandling.sequencing.SequencingPolicy)matchingConstructor.newInstance(parsedParameters);
        }

        private Constructor<?> findMatchingConstructor(Class<? extends org.axonframework.eventhandling.sequencing.SequencingPolicy> policyType, int parameterCount, MessageHandlingMember<T> original) {
            return Arrays.stream(policyType.getDeclaredConstructors()).filter(constructor -> this.countNonClassParameters((Constructor<?>)constructor) == (long)parameterCount).findFirst().orElseThrow(() -> new UnsupportedHandlerException("No constructor found for SequencingPolicy " + policyType.getName() + " that matches " + parameterCount + " string parameters (excluding Class parameters)", original.unwrap(Member.class).orElse(null)));
        }

        private long countNonClassParameters(Constructor<?> constructor) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            boolean hasClassAsFirstParam = paramTypes.length > 0 && paramTypes[0] == Class.class;
            return hasClassAsFirstParam ? (long)(paramTypes.length - 1) : (long)paramTypes.length;
        }

        private Object[] parseParameters(Class<?>[] parameterTypes, String[] stringParameters, MessageHandlingMember<T> original) {
            Object[] parsedParameters = new Object[parameterTypes.length];
            int stringParameterIndex = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> targetType = parameterTypes[i];
                if (targetType == Class.class) {
                    if (i != 0) {
                        throw new IllegalArgumentException("Class parameter must be the first parameter in constructor. Found at position: " + i);
                    }
                    parsedParameters[i] = original.payloadType();
                    continue;
                }
                if (stringParameterIndex >= stringParameters.length) {
                    throw new IllegalArgumentException("Not enough string parameters provided. Expected parameter for type: " + targetType.getName());
                }
                String stringValue = stringParameters[stringParameterIndex];
                parsedParameters[i] = this.parseParameter(stringValue, targetType);
                ++stringParameterIndex;
            }
            return parsedParameters;
        }

        private Object parseParameter(String stringValue, Class<?> targetType) {
            return switch (targetType.getName()) {
                case "java.lang.String" -> stringValue;
                case "int", "java.lang.Integer" -> Integer.parseInt(stringValue);
                case "long", "java.lang.Long" -> Long.parseLong(stringValue);
                case "double", "java.lang.Double" -> Double.parseDouble(stringValue);
                case "float", "java.lang.Float" -> Float.valueOf(Float.parseFloat(stringValue));
                case "boolean", "java.lang.Boolean" -> Boolean.parseBoolean(stringValue);
                case "byte", "java.lang.Byte" -> Byte.parseByte(stringValue);
                case "short", "java.lang.Short" -> Short.parseShort(stringValue);
                case "char", "java.lang.Character" -> Character.valueOf(this.parseCharacter(stringValue));
                case "java.lang.Class" -> this.parseClass(stringValue);
                default -> throw new UnsupportedOperationException("Unsupported parameter type: " + targetType.getName() + ". Only primitives, String, and Class are supported.");
            };
        }

        private char parseCharacter(String stringValue) {
            if (stringValue.length() != 1) {
                throw new IllegalArgumentException("Character parameter must be exactly one character");
            }
            return stringValue.charAt(0);
        }

        private Class<?> parseClass(String stringValue) {
            try {
                return Class.forName(stringValue);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find class: " + stringValue, e);
            }
        }
    }
}

