/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Optional;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.annotations.EventHandler;
import org.axonframework.eventhandling.annotations.EventHandlingMember;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.UnsupportedHandlerException;
import org.axonframework.messaging.annotations.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MethodEventHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        Optional optionalEventName = original.attribute("EventHandler.eventName");
        return original.unwrap(Method.class).filter(method -> method.isAnnotationPresent(EventHandler.class)).filter(method -> optionalEventName.isPresent()).map(method -> new MethodEventMessageHandlingMember(original, (String)optionalEventName.get())).orElse(original);
    }

    @Internal
    static class MethodEventMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements EventHandlingMember<T> {
        private final String eventName;

        private MethodEventMessageHandlingMember(MessageHandlingMember<T> delegate, String eventNameAttribute) {
            super(delegate);
            if (delegate.unwrap(Method.class).isEmpty()) {
                throw new UnsupportedHandlerException("@EventHandler annotation can only be put on methods.", delegate.unwrap(Member.class).orElse(null));
            }
            this.eventName = "".equals(eventNameAttribute) ? delegate.payloadType().getName() : eventNameAttribute;
        }

        @Override
        public boolean canHandle(@Nonnull Message message, @Nonnull ProcessingContext context) {
            return super.canHandle(message, context) && (message instanceof EventMessage || this.eventName.equals(message.type().name()));
        }

        @Override
        public String eventName() {
            return this.eventName;
        }
    }
}

