/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandPriorityCalculator;
import org.axonframework.commandhandling.InterceptingCommandBus;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotations.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.ConvertingCommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.InterceptingEventSink;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.ConfigurationApplicationContext;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.CorrelationDataProviderRegistry;
import org.axonframework.messaging.correlation.DefaultCorrelationDataProviderRegistry;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.interceptors.DefaultDispatchInterceptorRegistry;
import org.axonframework.messaging.interceptors.DefaultHandlerInterceptorRegistry;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;
import org.axonframework.messaging.interceptors.HandlerInterceptorRegistry;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.TransactionalUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryPriorityCalculator;
import org.axonframework.queryhandling.QueryUpdateEmitterParameterResolverFactory;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.json.JacksonConverter;

public class MessagingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;
    public static final int CONVERTING_COMMAND_GATEWAY_ORDER = -2147483548;

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void enhance(@Nonnull ComponentRegistry registry) {
        MessagingConfigurationDefaults.registerComponents(registry);
        MessagingConfigurationDefaults.registerDecorators(registry);
    }

    private static void registerComponents(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(MessageTypeResolver.class, MessagingConfigurationDefaults::defaultMessageTypeResolver).registerIfNotPresent(Converter.class, c -> new JacksonConverter()).registerIfNotPresent(MessageConverter.class, MessagingConfigurationDefaults::defaultMessageConverter).registerIfNotPresent(EventConverter.class, MessagingConfigurationDefaults::defaultEventConverter).registerIfNotPresent(UnitOfWorkFactory.class, MessagingConfigurationDefaults::defaultUnitOfWorkFactory).registerIfNotPresent(CorrelationDataProviderRegistry.class, MessagingConfigurationDefaults::defaultCorrelationDataProviderRegistry).registerIfNotPresent(DispatchInterceptorRegistry.class, MessagingConfigurationDefaults::defaultDispatchInterceptorRegistry).registerIfNotPresent(HandlerInterceptorRegistry.class, MessagingConfigurationDefaults::defaultHandlerInterceptorRegistry).registerIfNotPresent(CommandBus.class, MessagingConfigurationDefaults::defaultCommandBus).registerIfNotPresent(CommandPriorityCalculator.class, c -> CommandPriorityCalculator.defaultCalculator()).registerIfNotPresent(RoutingStrategy.class, MessagingConfigurationDefaults::defaultRoutingStrategy).registerIfNotPresent(CommandGateway.class, MessagingConfigurationDefaults::defaultCommandGateway).registerIfNotPresent(EventGateway.class, MessagingConfigurationDefaults::defaultEventGateway).registerIfNotPresent(EventSink.class, MessagingConfigurationDefaults::defaultEventSink).registerIfNotPresent(EventBus.class, MessagingConfigurationDefaults::defaultEventBus).registerIfNotPresent(QueryBus.class, MessagingConfigurationDefaults::defaultQueryBus).registerIfNotPresent(QueryPriorityCalculator.class, c -> QueryPriorityCalculator.defaultCalculator()).registerIfNotPresent(QueryGateway.class, MessagingConfigurationDefaults::defaultQueryGateway);
        ParameterResolverFactoryUtils.registerToComponentRegistry(registry, config -> new QueryUpdateEmitterParameterResolverFactory());
    }

    private static MessageTypeResolver defaultMessageTypeResolver(Configuration config) {
        return new ClassBasedMessageTypeResolver();
    }

    private static DelegatingMessageConverter defaultMessageConverter(Configuration c) {
        return new DelegatingMessageConverter(c.getComponent(Converter.class));
    }

    private static DelegatingEventConverter defaultEventConverter(Configuration c) {
        return c.getOptionalComponent(MessageConverter.class).map(DelegatingEventConverter::new).orElse(new DelegatingEventConverter(c.getComponent(Converter.class)));
    }

    private static UnitOfWorkFactory defaultUnitOfWorkFactory(Configuration config) {
        return new TransactionalUnitOfWorkFactory(config.getComponent(TransactionManager.class, NoTransactionManager::instance), new SimpleUnitOfWorkFactory(new ConfigurationApplicationContext(config)));
    }

    private static CorrelationDataProviderRegistry defaultCorrelationDataProviderRegistry(Configuration config) {
        return new DefaultCorrelationDataProviderRegistry().registerProvider(c -> new MessageOriginProvider());
    }

    private static DispatchInterceptorRegistry defaultDispatchInterceptorRegistry(Configuration config) {
        CorrelationDataProviderRegistry providerRegistry = config.getComponent(CorrelationDataProviderRegistry.class);
        List<CorrelationDataProvider> providers = providerRegistry.correlationDataProviders(config);
        DefaultDispatchInterceptorRegistry dispatchInterceptorRegistry = new DefaultDispatchInterceptorRegistry();
        return providers.isEmpty() ? dispatchInterceptorRegistry : dispatchInterceptorRegistry.registerInterceptor(c -> new CorrelationDataInterceptor(providers));
    }

    private static HandlerInterceptorRegistry defaultHandlerInterceptorRegistry(Configuration config) {
        CorrelationDataProviderRegistry providerRegistry = config.getComponent(CorrelationDataProviderRegistry.class);
        List<CorrelationDataProvider> providers = providerRegistry.correlationDataProviders(config);
        DefaultHandlerInterceptorRegistry handlerInterceptorRegistry = new DefaultHandlerInterceptorRegistry();
        return providers.isEmpty() ? handlerInterceptorRegistry : handlerInterceptorRegistry.registerInterceptor(c -> new CorrelationDataInterceptor(providers));
    }

    private static CommandBus defaultCommandBus(Configuration config) {
        return new SimpleCommandBus(config.getComponent(UnitOfWorkFactory.class), config.getOptionalComponent(TransactionManager.class).map(tm -> tm).map(List::of).orElse(Collections.emptyList()));
    }

    private static RoutingStrategy defaultRoutingStrategy(Configuration config) {
        return new AnnotationRoutingStrategy();
    }

    private static CommandGateway defaultCommandGateway(Configuration config) {
        return new DefaultCommandGateway(config.getComponent(CommandBus.class), config.getComponent(MessageTypeResolver.class), config.getComponent(CommandPriorityCalculator.class), config.getComponent(RoutingStrategy.class));
    }

    private static EventBus defaultEventBus(Configuration config) {
        return SimpleEventBus.builder().build();
    }

    private static EventSink defaultEventSink(Configuration config) {
        final EventBus eventBus = config.getComponent(EventBus.class);
        return new EventSink(){

            @Override
            public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
                eventBus.publish(events);
                return FutureUtils.emptyCompletedFuture();
            }

            @Override
            public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            }
        };
    }

    private static EventGateway defaultEventGateway(Configuration config) {
        return new DefaultEventGateway(config.getComponent(EventSink.class), config.getComponent(MessageTypeResolver.class));
    }

    private static QueryGateway defaultQueryGateway(Configuration config) {
        return new DefaultQueryGateway(config.getComponent(QueryBus.class), config.getComponent(MessageTypeResolver.class), config.getComponent(QueryPriorityCalculator.class));
    }

    private static QueryBus defaultQueryBus(Configuration config) {
        return new SimpleQueryBus(config.getComponent(UnitOfWorkFactory.class));
    }

    private static void registerDecorators(@Nonnull ComponentRegistry registry) {
        registry.registerDecorator(CommandGateway.class, -2147483548, (config, name, delegate) -> new ConvertingCommandGateway((CommandGateway)delegate, config.getComponent(MessageConverter.class)));
        registry.registerDecorator(CommandBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageHandlerInterceptor<CommandMessage>> handlerInterceptors = config.getComponent(HandlerInterceptorRegistry.class).commandInterceptors(config);
            List<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).commandInterceptors(config);
            return handlerInterceptors.isEmpty() && dispatchInterceptors.isEmpty() ? delegate : new InterceptingCommandBus((CommandBus)delegate, handlerInterceptors, dispatchInterceptors);
        });
        registry.registerDecorator(EventSink.class, -2147483548, (config, name, delegate) -> {
            if (!MessagingConfigurationDefaults.isDirectImplementationOf(delegate, EventSink.class)) {
                return delegate;
            }
            List<MessageDispatchInterceptor<? super EventMessage>> dispatchInterceptors = config.getComponent(DispatchInterceptorRegistry.class).eventInterceptors(config);
            return dispatchInterceptors.isEmpty() ? delegate : new InterceptingEventSink((EventSink)delegate, dispatchInterceptors);
        });
    }

    private static boolean isDirectImplementationOf(@Nonnull Object component, @Nonnull Class<EventSink> clazz) {
        return Arrays.stream(component.getClass().getInterfaces()).anyMatch(iface -> iface == clazz);
    }
}

