/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.AbstractComponent;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LifecycleRegistry;

class DecoratedComponent<C, D extends C>
extends AbstractComponent<C, D> {
    private final Component<C> delegate;
    private final ComponentDecorator<C, D> decorator;
    private final AtomicReference<D> instanceReference = new AtomicReference();

    DecoratedComponent(@Nonnull Component<C> delegate, @Nonnull ComponentDecorator<C, D> decorator, @Nonnull List<AbstractComponent.HandlerRegistration<D>> startHandlers, @Nonnull List<AbstractComponent.HandlerRegistration<D>> shutdownHandlers) {
        super(Objects.requireNonNull(delegate, "The delegate cannot be null.").identifier(), startHandlers, shutdownHandlers);
        this.delegate = delegate;
        this.decorator = decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D doResolve(@Nonnull Configuration configuration) {
        D existingInstance = this.instanceReference.get();
        if (existingInstance != null) {
            return existingInstance;
        }
        DecoratedComponent decoratedComponent = this;
        synchronized (decoratedComponent) {
            return this.instanceReference.updateAndGet(instance -> {
                D decorated;
                if (instance != null) {
                    return instance;
                }
                Class<C> originalType = this.delegate.identifier().typeAsClass();
                if (originalType.isAssignableFrom((decorated = this.decorator.decorate(configuration, this.identifier().name(), this.delegate.resolve(configuration))).getClass())) {
                    return decorated;
                }
                throw new ClassCastException(String.format("Original component type [%s] is not assignable to decorated component type [%s]. Make sure decorators return matching components, as component retrieval otherwise fails!", originalType, decorated.getClass()));
            });
        }
    }

    @Override
    public boolean isInstantiated() {
        return this.instanceReference.get() != null;
    }

    @Override
    public void initLifecycle(@Nonnull Configuration configuration, @Nonnull LifecycleRegistry lifecycleRegistry) {
        this.delegate.initLifecycle(configuration, lifecycleRegistry);
        super.initLifecycle(configuration, lifecycleRegistry);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        D instance = this.instanceReference.get();
        if (instance != null) {
            descriptor.describeProperty("instance", instance);
        } else {
            descriptor.describeProperty("decorator", this.decorator);
            descriptor.describeWrapperOf(this.delegate);
        }
    }
}

