/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.common.Assert;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.DefaultComponentRegistry;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.Module;

public abstract class BaseModule<S extends BaseModule<S>>
implements Module {
    private final DefaultComponentRegistry componentRegistry;
    protected final String name;

    protected BaseModule(@Nonnull String name) {
        this.name = Assert.nonEmpty(name, "The Module name cannot be null or empty.");
        this.componentRegistry = new DefaultComponentRegistry();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Configuration build(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        return this.postProcessConfiguration(this.componentRegistry.disableEnhancerScanning().buildNested(parent, lifecycleRegistry));
    }

    protected Configuration postProcessConfiguration(Configuration moduleConfiguration) {
        return moduleConfiguration;
    }

    public S componentRegistry(@Nonnull Consumer<ComponentRegistry> registryAction) {
        Objects.requireNonNull(registryAction, "The registryAction must be null.").accept(this.componentRegistry);
        return (S)this;
    }
}

