/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.annotations.RoutingKey;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotations.AnnotationUtils;

public class AnnotationRoutingStrategy
implements RoutingStrategy {
    private static final RoutingKeyResolver NO_RESOLVE = new RoutingKeyResolver((Method)null);
    private static final String NULL_DEFAULT = null;
    private final Class<? extends Annotation> annotationType;
    private final Map<Class<?>, RoutingKeyResolver> resolverMap = new ConcurrentHashMap();

    public AnnotationRoutingStrategy() {
        this(RoutingKey.class);
    }

    public AnnotationRoutingStrategy(@Nonnull Class<? extends Annotation> annotationType) {
        this.annotationType = Objects.requireNonNull(annotationType, "The annotationType can not be null.");
    }

    @Override
    public String getRoutingKey(@Nonnull CommandMessage command) {
        try {
            Object payload = command.payload();
            return payload == null ? null : this.findIdentifier(payload);
        }
        catch (InvocationTargetException e) {
            throw new AxonConfigurationException("An exception occurred while extracting routing information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new AxonConfigurationException("The current security context does not allow extraction of routing information from the given command.", e);
        }
    }

    private String findIdentifier(Object payload) throws InvocationTargetException, IllegalAccessException {
        return this.resolverMap.computeIfAbsent(payload.getClass(), this::createResolver).identify(payload);
    }

    private RoutingKeyResolver createResolver(Class<?> type) {
        for (Field f : ReflectionUtils.fieldsOf(type)) {
            if (!AnnotationUtils.findAnnotationAttributes((AnnotatedElement)f, this.annotationType).isPresent()) continue;
            return new RoutingKeyResolver(f);
        }
        for (Method m : ReflectionUtils.methodsOf(type)) {
            if (!AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, this.annotationType).isPresent()) continue;
            ReflectionUtils.ensureAccessible(m);
            return new RoutingKeyResolver(m);
        }
        return NO_RESOLVE;
    }

    private static final class RoutingKeyResolver {
        private final Method method;
        private final Field field;

        public RoutingKeyResolver(Method method) {
            this.method = method;
            this.field = null;
        }

        public RoutingKeyResolver(Field field) {
            this.method = null;
            this.field = field;
        }

        public String identify(Object command) throws InvocationTargetException, IllegalAccessException {
            if (this.method != null) {
                return Objects.toString(this.method.invoke(command, new Object[0]), NULL_DEFAULT);
            }
            if (this.field != null) {
                return Objects.toString(ReflectionUtils.getFieldValue(this.field, command), NULL_DEFAULT);
            }
            return null;
        }
    }
}

