/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.tracing;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.tracing.SpanScope;

public interface Span {
    public Span start();

    default public SpanScope makeCurrent() {
        return () -> {};
    }

    public void end();

    public Span recordException(Throwable var1);

    default public void run(Runnable runnable) {
        this.start();
        try (SpanScope unused = this.makeCurrent();){
            runnable.run();
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
        finally {
            this.end();
        }
    }

    default public Runnable wrapRunnable(Runnable runnable) {
        return () -> this.run(runnable);
    }

    default public <T> T runCallable(Callable<T> callable) throws Exception {
        this.start();
        try {
            T t;
            block11: {
                SpanScope unused = this.makeCurrent();
                try {
                    t = callable.call();
                    if (unused == null) break block11;
                    unused.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.recordException(e);
                        throw e;
                    }
                }
            }
            return t;
        }
        finally {
            this.end();
        }
    }

    default public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return () -> this.runCallable(callable);
    }

    default public <T> T runSupplier(Supplier<T> supplier) {
        this.start();
        try {
            T t;
            block11: {
                SpanScope unused = this.makeCurrent();
                try {
                    t = supplier.get();
                    if (unused == null) break block11;
                    unused.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (unused != null) {
                            try {
                                unused.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.recordException(e);
                        throw e;
                    }
                }
            }
            return t;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> CompletableFuture<T> runSupplierAsync(Supplier<CompletableFuture<T>> supplier) {
        this.start();
        CompletionStage future = new CompletableFuture();
        try (SpanScope ignored = this.makeCurrent();){
            supplier.get().whenComplete(FutureUtils.alsoComplete(future));
        }
        catch (Exception e2) {
            ((CompletableFuture)future).completeExceptionally(e2);
        }
        finally {
            future = ((CompletableFuture)future).whenComplete((r, e) -> {
                if (e != null) {
                    this.recordException((Throwable)e);
                }
                this.end();
            });
        }
        return future;
    }

    default public <T> Supplier<T> wrapSupplier(Supplier<T> supplier) {
        return () -> this.runSupplier(supplier);
    }

    default public <T> void runConsumer(Consumer<T> supplier, T consumedObject) {
        this.start();
        try (SpanScope unused = this.makeCurrent();){
            supplier.accept(consumedObject);
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
        finally {
            this.end();
        }
    }

    default public <T> Consumer<T> wrapConsumer(Consumer<T> supplier) {
        return consumedObject -> this.runConsumer(supplier, consumedObject);
    }

    default public Span addAttribute(String key, String value) {
        return this;
    }
}

