/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.queryhandling.QueryBus;
import org.axonframework.messaging.queryhandling.QueryHandler;
import org.axonframework.messaging.queryhandling.QueryHandlingComponent;
import org.axonframework.messaging.queryhandling.SimpleQueryHandlingComponent;
import org.axonframework.messaging.queryhandling.configuration.QueryHandlingModule;

class SimpleQueryHandlingModule
extends BaseModule<SimpleQueryHandlingModule>
implements QueryHandlingModule,
QueryHandlingModule.SetupPhase,
QueryHandlingModule.QueryHandlerPhase {
    private final String queryHandlingComponentName;
    private final Map<QualifiedName, ComponentBuilder<QueryHandler>> handlerBuilders;
    private final List<ComponentBuilder<QueryHandlingComponent>> handlingComponentBuilders;

    SimpleQueryHandlingModule(@Nonnull String moduleName) {
        super(Objects.requireNonNull(moduleName, "The module name cannot be null."));
        this.queryHandlingComponentName = "QueryHandlingComponent[" + moduleName + "]";
        this.handlerBuilders = new HashMap<QualifiedName, ComponentBuilder<QueryHandler>>();
        this.handlingComponentBuilders = new ArrayList<ComponentBuilder<QueryHandlingComponent>>();
    }

    @Override
    public QueryHandlingModule.QueryHandlerPhase queryHandlers() {
        return this;
    }

    @Override
    public QueryHandlingModule.QueryHandlerPhase queryHandler(@Nonnull QualifiedName queryName, @Nonnull ComponentBuilder<QueryHandler> queryHandlerBuilder) {
        this.handlerBuilders.put(Objects.requireNonNull(queryName, "queryName must not be null"), Objects.requireNonNull(queryHandlerBuilder, "The query handler builder cannot be null."));
        return this;
    }

    @Override
    public QueryHandlingModule.QueryHandlerPhase queryHandlingComponent(@Nonnull ComponentBuilder<QueryHandlingComponent> handlingComponentBuilder) {
        this.handlingComponentBuilders.add(Objects.requireNonNull(handlingComponentBuilder, "The query handling component builder cannot be null."));
        return this;
    }

    @Override
    public QueryHandlingModule build() {
        this.registerQueryHandlingComponent();
        return this;
    }

    private void registerQueryHandlingComponent() {
        this.componentRegistry(cr -> cr.registerComponent(this.queryHandlingComponentComponentDefinition()));
    }

    private ComponentDefinition<QueryHandlingComponent> queryHandlingComponentComponentDefinition() {
        return ComponentDefinition.ofTypeAndName(QueryHandlingComponent.class, this.queryHandlingComponentName).withBuilder(c -> {
            SimpleQueryHandlingComponent queryHandlingComponent = SimpleQueryHandlingComponent.create(this.queryHandlingComponentName);
            this.handlingComponentBuilders.forEach(handlingComponent -> queryHandlingComponent.subscribe((QueryHandlingComponent)handlingComponent.build(c)));
            this.handlerBuilders.forEach((key, value) -> queryHandlingComponent.subscribe((QualifiedName)key, (QueryHandler)value.build(c)));
            return queryHandlingComponent;
        }).onStart(0, (configuration, component) -> {
            configuration.getComponent(QueryBus.class).subscribe(configuration.getComponent(QueryHandlingComponent.class, this.queryHandlingComponentName));
            return FutureUtils.emptyCompletedFuture();
        });
    }
}

