/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring.interception;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageDispatchInterceptorChain;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;

public class MonitoringSubscriptionQueryUpdateDispatchInterceptor
implements MessageDispatchInterceptor<SubscriptionQueryUpdateMessage> {
    private final MessageMonitor<? super SubscriptionQueryUpdateMessage> messageMonitor;

    public MonitoringSubscriptionQueryUpdateDispatchInterceptor(@Nonnull MessageMonitor<? super SubscriptionQueryUpdateMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull SubscriptionQueryUpdateMessage message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<SubscriptionQueryUpdateMessage> interceptorChain) {
        if (context != null && context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

