/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token.store.jdbc;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.axonframework.common.ClassUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.Segment;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;

public class JdbcTokenEntry {
    public static Clock clock = Clock.systemUTC();
    private byte[] token;
    private String tokenType;
    private String timestamp;
    private String owner;
    private String processorName;
    private Segment segment;

    public JdbcTokenEntry(@Nullable TrackingToken token, @Nonnull Converter converter) {
        this.updateToken(token, converter);
    }

    public JdbcTokenEntry(byte[] token, String tokenType, String timestamp, String owner, @Nonnull String processorName, @Nonnull Segment segment) {
        this.token = token;
        this.tokenType = tokenType;
        this.timestamp = timestamp;
        this.owner = owner;
        this.processorName = processorName;
        this.segment = segment;
    }

    protected JdbcTokenEntry() {
    }

    public TrackingToken getToken(@Nonnull Converter converter) {
        if (this.token == null || this.tokenType == null) {
            return null;
        }
        Class type = ClassUtils.loadClass(this.tokenType);
        return (TrackingToken)converter.convert((Object)this.token, type);
    }

    public Instant timestamp() {
        return DateTimeUtils.parseInstant(this.timestamp);
    }

    public String timestampAsString() {
        return this.timestamp;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public String getOwner() {
        return this.owner;
    }

    public byte[] getTokenData() {
        return this.token;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean claim(String owner, TemporalAmount claimTimeout) {
        if (!this.mayClaim(owner, claimTimeout)) {
            return false;
        }
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        this.owner = owner;
        return true;
    }

    public boolean mayClaim(String owner, TemporalAmount claimTimeout) {
        return this.owner == null || owner.equals(this.owner) || this.expired(claimTimeout);
    }

    private boolean expired(TemporalAmount claimTimeout) {
        return this.timestamp().plus(claimTimeout).isBefore(clock.instant());
    }

    public boolean releaseClaim(String owner) {
        if (Objects.equals(this.owner, owner)) {
            this.owner = null;
            this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        }
        return this.owner == null;
    }

    public final void updateToken(@Nullable TrackingToken token, @Nonnull Converter converter) {
        this.timestamp = DateTimeUtils.formatInstant(clock.instant());
        if (token != null) {
            this.token = converter.convert((Object)token, byte[].class);
            this.tokenType = token.getClass().getName();
        } else {
            this.token = null;
            this.tokenType = null;
        }
    }
}

