/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.pooled;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.processing.ProcessorEventHandlingComponents;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorContext;
import org.axonframework.messaging.eventhandling.processing.errorhandling.ErrorHandler;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.WorkPackage;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.Segment;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.SegmentMatcher;

@Internal
class DefaultWorkPackageEventFilter
implements WorkPackage.EventFilter {
    private final String eventProcessor;
    private final ProcessorEventHandlingComponents eventHandlingComponents;
    private final ErrorHandler errorHandler;

    DefaultWorkPackageEventFilter(@Nonnull String eventProcessor, @Nonnull ProcessorEventHandlingComponents eventHandlingComponents, @Nonnull ErrorHandler errorHandler) {
        this.eventProcessor = Objects.requireNonNull(eventProcessor, "EventProcessor name may not be null");
        this.eventHandlingComponents = Objects.requireNonNull(eventHandlingComponents, "ProcessorEventHandlingComponents may not be null");
        this.errorHandler = Objects.requireNonNull(errorHandler, "ErrorHandler may not be null");
    }

    @Override
    public boolean canHandle(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context, @Nonnull Segment segment) throws Exception {
        try {
            QualifiedName eventMessageQualifiedName = eventMessage.type().qualifiedName();
            boolean eventSupported = this.eventHandlingComponents.supports(eventMessageQualifiedName);
            if (!eventSupported) {
                return false;
            }
            Set<Object> sequenceIdentifiers = this.eventHandlingComponents.sequenceIdentifiersFor(eventMessage, context);
            return sequenceIdentifiers.stream().anyMatch(identifier -> new SegmentMatcher((e, ctx) -> Optional.of(identifier)).matches(segment, eventMessage, context));
        }
        catch (Exception e) {
            this.errorHandler.handleError(new ErrorContext(this.eventProcessor, e, Collections.singletonList(eventMessage), context));
            return false;
        }
    }
}

