/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.retry;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.retry.DoNotRetryOutcome;
import org.axonframework.messaging.core.retry.RetryOutcome;

public interface RetryPolicy
extends DescribableComponent {
    public Outcome defineFor(@Nonnull Message var1, @Nonnull Throwable var2, @Nonnull List<Class<? extends Throwable>[]> var3);

    public static sealed interface Outcome
    permits RetryOutcome, DoNotRetryOutcome {
        public static Outcome rescheduleIn(long interval, TimeUnit timeUnit) {
            return new RetryOutcome(interval, timeUnit);
        }

        public static Outcome doNotReschedule() {
            return new DoNotRetryOutcome();
        }

        public boolean shouldReschedule();

        public long rescheduleInterval();

        public TimeUnit rescheduleIntervalTimeUnit();
    }
}

