/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.retry;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.retry.RetryPolicy;

public class ExponentialBackOffRetryPolicy
implements RetryPolicy {
    private final long initialWaitTime;

    public ExponentialBackOffRetryPolicy(long initialWaitTime) {
        this.initialWaitTime = initialWaitTime;
    }

    @Override
    public RetryPolicy.Outcome defineFor(@Nonnull Message message, @Nonnull Throwable failure, @Nonnull List<Class<? extends Throwable>[]> previousFailures) {
        if (Long.numberOfLeadingZeros(this.initialWaitTime) <= previousFailures.size()) {
            return RetryPolicy.Outcome.rescheduleIn(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        long waitTime = this.initialWaitTime << previousFailures.size();
        return RetryPolicy.Outcome.rescheduleIn(waitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("initialWaitTime", this.initialWaitTime);
    }
}

