/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.LegacyResources;
import org.axonframework.messaging.core.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.SourceId;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class SourceIdParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<SourceId, String> {
    private final ParameterResolver<String> resolver = new SourceIdParameterResolver();

    public SourceIdParameterResolverFactory() {
        super(SourceId.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class SourceIdParameterResolver
    implements ParameterResolver<String> {
        SourceIdParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<String> resolveParameterValue(@Nonnull ProcessingContext context) {
            String sourceId = context.getResource(LegacyResources.AGGREGATE_IDENTIFIER_KEY);
            if (sourceId != null) {
                return CompletableFuture.completedFuture(sourceId);
            }
            return CompletableFuture.failedFuture(new IllegalArgumentException("No sourceId found"));
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(LegacyResources.AGGREGATE_IDENTIFIER_KEY);
        }
    }
}

