/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.core.annotation.MessageIdentifier;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class MessageIdentifierParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<MessageIdentifier, String> {
    private final ParameterResolver<String> resolver = new MessageIdentifierParameterResolver();

    public MessageIdentifierParameterResolverFactory() {
        super(MessageIdentifier.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class MessageIdentifierParameterResolver
    implements ParameterResolver<String> {
        MessageIdentifierParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<String> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(Message.fromContext(context).identifier());
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) != null;
        }
    }
}

