/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.messaging.core.Context;

public class SimpleContext
implements Context {
    private final Map<Context.ResourceKey<?>, Object> resources;

    public <T> SimpleContext(Context.ResourceKey<T> key, T value) {
        this(Map.of(key, value));
    }

    private SimpleContext(Map<Context.ResourceKey<?>, Object> resources) {
        this.resources = resources;
    }

    @Override
    public boolean containsResource(@Nonnull Context.ResourceKey<?> key) {
        return this.resources.containsKey(key);
    }

    @Override
    public <T> T getResource(@Nonnull Context.ResourceKey<T> key) {
        return (T)this.resources.get(key);
    }

    @Override
    public <T> Context withResource(@Nonnull Context.ResourceKey<T> key, @Nonnull T resource) {
        ConcurrentHashMap newResources = new ConcurrentHashMap(this.resources);
        newResources.put(key, resource);
        return new SimpleContext(newResources);
    }

    @Override
    public Map<Context.ResourceKey<?>, Object> resources() {
        return Map.copyOf(this.resources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleContext that = (SimpleContext)o;
        return Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hashCode(this.resources);
    }

    public String toString() {
        return "SimpleContext{resources=" + String.valueOf(this.resources) + "}";
    }
}

