/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class Metadata
implements Map<String, String> {
    private static final Metadata EMPTY_METADATA = new Metadata();
    private static final String UNSUPPORTED_MUTATION_MSG = "Metadata is immutable.";
    private final Map<String, String> values;

    private Metadata() {
        this.values = Collections.emptyMap();
    }

    public Metadata(@Nonnull Map<String, String> items) {
        this.values = Collections.unmodifiableMap(new HashMap<String, String>(items));
    }

    public static Metadata emptyInstance() {
        return EMPTY_METADATA;
    }

    public static Metadata from(@Nullable Map<String, String> metadataEntries) {
        if (metadataEntries instanceof Metadata) {
            return (Metadata)metadataEntries;
        }
        if (metadataEntries == null || metadataEntries.isEmpty()) {
            return Metadata.emptyInstance();
        }
        return new Metadata(metadataEntries);
    }

    public static Metadata with(@Nonnull String key, @Nullable String value) {
        return Metadata.from(Collections.singletonMap(key, value));
    }

    public Metadata and(@Nonnull String key, @Nullable String value) {
        HashMap<String, String> newValues = new HashMap<String, String>(this.values);
        newValues.put(key, value);
        return new Metadata(newValues);
    }

    public Metadata andIfNotPresent(@Nonnull String key, @Nonnull Supplier<String> value) {
        return this.containsKey(key) ? this : this.and(key, value.get());
    }

    public Metadata mergedWith(@Nonnull Map<String, String> additionalEntries) {
        if (additionalEntries.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return Metadata.from(additionalEntries);
        }
        HashMap<String, String> merged = new HashMap<String, String>(this.values);
        merged.putAll(additionalEntries);
        return new Metadata(merged);
    }

    public Metadata withoutKeys(@Nonnull Set<String> keys) {
        if (keys.isEmpty()) {
            return this;
        }
        HashMap<String, String> modified = new HashMap<String, String>(this.values);
        keys.forEach(modified::remove);
        return new Metadata(modified);
    }

    public Metadata subset(String ... keys) {
        return Metadata.from(Stream.of(keys).filter(this::containsKey).collect(new MetadataCollector(this::get)));
    }

    @Override
    @Nullable
    public String get(Object key) {
        return this.values.get(key);
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNSUPPORTED_MUTATION_MSG);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.values.equals(that);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.values.forEach((k, v) -> sb.append(", '").append((String)k).append("'->'").append((String)v).append('\''));
        int skipInitialListingAppendString = 2;
        return this.values.isEmpty() ? sb.toString() : sb.substring(skipInitialListingAppendString);
    }

    private record MetadataCollector(Function<String, String> valueProvider) implements Collector<String, Map<String, String>, Metadata>
    {
        @Override
        public Supplier<Map<String, String>> supplier() {
            return HashMap::new;
        }

        @Override
        public BiConsumer<Map<String, String>, String> accumulator() {
            return (map, key) -> map.put(key, this.valueProvider.apply((String)key));
        }

        @Override
        public BinaryOperator<Map<String, String>> combiner() {
            return (m1, m2) -> {
                HashMap result = new HashMap(m1);
                result.putAll(m2);
                return result;
            };
        }

        @Override
        public Function<Map<String, String>, Metadata> finisher() {
            return Metadata::from;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

