/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.ObjectUtils;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.GenericMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDecorator;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.core.ResultMessage;

public class GenericResultMessage
extends MessageDecorator
implements ResultMessage {
    public GenericResultMessage(@Nonnull MessageType type, @Nullable Object result) {
        this(type, result, Metadata.emptyInstance());
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nullable Object result, @Nonnull Map<String, String> metadata) {
        this(new GenericMessage(type, result, metadata));
    }

    public GenericResultMessage(@Nonnull Message delegate) {
        super(delegate);
    }

    @Deprecated
    public static ResultMessage asResultMessage(Object result) {
        if (result instanceof ResultMessage) {
            ResultMessage r = (ResultMessage)result;
            return r;
        }
        if (result instanceof Message) {
            Message resultMessage = (Message)result;
            return new GenericResultMessage(resultMessage);
        }
        MessageType type = result == null ? new MessageType("empty.result") : new MessageType(result.getClass());
        return new GenericResultMessage(type, result);
    }

    @Override
    @Nonnull
    public ResultMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericResultMessage(this.delegate().withMetadata(metadata));
    }

    @Override
    @Nonnull
    public ResultMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericResultMessage(this.delegate().andMetadata(metadata));
    }

    @Override
    @Nonnull
    public ResultMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return new GenericResultMessage(converted);
    }

    @Override
    protected String describeType() {
        return "GenericResultMessage";
    }
}

