/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryHandlerName;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.distributed.QueryBusConnector;

public abstract class DelegatingQueryBusConnector
implements QueryBusConnector {
    protected final QueryBusConnector delegate;

    protected DelegatingQueryBusConnector(@Nonnull QueryBusConnector delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate must not be null.");
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
        return this.delegate.query(query, context);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> subscriptionQuery(@Nonnull SubscriptionQueryMessage query, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.delegate.subscriptionQuery(query, context, updateBufferSize);
    }

    @Override
    public CompletableFuture<Void> subscribe(@Nonnull QueryHandlerName name) {
        return this.delegate.subscribe(name);
    }

    @Override
    public boolean unsubscribe(@Nonnull QueryHandlerName name) {
        return this.delegate.unsubscribe(name);
    }

    @Override
    public void onIncomingQuery(@Nonnull QueryBusConnector.Handler handler) {
        this.delegate.onIncomingQuery(handler);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
    }
}

