/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryUpdateEmitter
implements QueryUpdateEmitter {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryUpdateEmitter.class);
    private final QueryBus queryBus;
    private final MessageTypeResolver messageTypeResolver;
    private final MessageConverter converter;
    private final ProcessingContext context;

    public SimpleQueryUpdateEmitter(@Nonnull QueryBus queryBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter converter, @Nonnull ProcessingContext context) {
        this.queryBus = Objects.requireNonNull(queryBus, "The QueryBus must not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver must not be null.");
        this.converter = Objects.requireNonNull(converter, "The MessageConverter must not be null.");
        this.context = Objects.requireNonNull(context, "The ProcessingContext must not be null.");
    }

    @Override
    public <Q> void emit(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull Supplier<Object> updateSupplier) {
        if (logger.isDebugEnabled()) {
            logger.debug("Emitting an update to queries matching type [{}] and a given filter.", queryType);
        }
        this.queryBus.emitUpdate(this.queryTypeFilter(queryType, filter), () -> this.asUpdateMessage(updateSupplier.get()), this.context).join();
    }

    @Override
    public void emit(@Nonnull QualifiedName queryName, @Nonnull Predicate<Object> filter, @Nonnull Supplier<Object> updateSupplier) {
        if (logger.isDebugEnabled()) {
            logger.debug("Emitting an update to queries matching name [{}] and a given filter.", (Object)queryName);
        }
        this.queryBus.emitUpdate(SimpleQueryUpdateEmitter.queryNameFilter(queryName, filter), () -> this.asUpdateMessage(updateSupplier.get()), this.context).join();
    }

    private SubscriptionQueryUpdateMessage asUpdateMessage(Object update) {
        GenericSubscriptionQueryUpdateMessage genericSubscriptionQueryUpdateMessage;
        if (update instanceof SubscriptionQueryUpdateMessage) {
            SubscriptionQueryUpdateMessage updateMessage = (SubscriptionQueryUpdateMessage)update;
            return updateMessage;
        }
        if (update instanceof Message) {
            Message updateMessage = (Message)update;
            genericSubscriptionQueryUpdateMessage = new GenericSubscriptionQueryUpdateMessage(updateMessage);
        } else {
            genericSubscriptionQueryUpdateMessage = new GenericSubscriptionQueryUpdateMessage(this.messageTypeResolver.resolveOrThrow(update), update);
        }
        return genericSubscriptionQueryUpdateMessage;
    }

    @Override
    public <Q> void complete(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Completing subscription queries of type [{}].", queryType);
        }
        this.queryBus.completeSubscriptions(this.queryTypeFilter(queryType, filter), this.context).join();
    }

    @Override
    public void complete(@Nonnull QualifiedName queryName, @Nonnull Predicate<Object> filter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Completing subscription queries with name [{}].", (Object)queryName);
        }
        this.queryBus.completeSubscriptions(SimpleQueryUpdateEmitter.queryNameFilter(queryName, filter), this.context).join();
    }

    @Override
    public <Q> void completeExceptionally(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug("Completing subscription queries of type [{}] exceptionally.", queryType, (Object)cause);
        }
        this.queryBus.completeSubscriptionsExceptionally(this.queryTypeFilter(queryType, filter), cause, this.context).join();
    }

    @Override
    public void completeExceptionally(@Nonnull QualifiedName queryName, @Nonnull Predicate<Object> filter, @Nonnull Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug("Completing subscription queries with name [{}] exceptionally.", (Object)queryName, (Object)cause);
        }
        this.queryBus.completeSubscriptionsExceptionally(SimpleQueryUpdateEmitter.queryNameFilter(queryName, filter), cause, this.context).join();
    }

    @Nonnull
    private <Q> Predicate<SubscriptionQueryMessage> queryTypeFilter(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter) {
        return message -> {
            QualifiedName queryName = this.messageTypeResolver.resolveOrThrow(queryType).qualifiedName();
            return queryName.equals(message.type().qualifiedName()) && filter.test((Object)message.payloadAs(queryType, (Converter)this.converter));
        };
    }

    @Nonnull
    private static Predicate<SubscriptionQueryMessage> queryNameFilter(@Nonnull QualifiedName queryName, @Nonnull Predicate<Object> filter) {
        return message -> queryName.equals(message.type().qualifiedName()) && filter.test(message.payload());
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("queryBus", this.queryBus);
        descriptor.describeProperty("messageTypeResolver", this.messageTypeResolver);
        descriptor.describeProperty("converter", this.converter);
        descriptor.describeProperty("context", this.context);
    }
}

