/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Set;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlerName;
import org.axonframework.queryhandling.QueryHandlingComponent;

public interface QueryHandlerRegistry<S extends QueryHandlerRegistry<S>> {
    default public S subscribe(@Nonnull Set<QueryHandlerName> names, @Nonnull QueryHandler queryHandler) {
        names.forEach(name -> this.subscribe((QueryHandlerName)name, queryHandler));
        return (S)this;
    }

    default public S subscribe(@Nonnull QualifiedName queryName, @Nonnull QualifiedName responseName, @Nonnull QueryHandler queryHandler) {
        return this.subscribe(new QueryHandlerName(queryName, responseName), queryHandler);
    }

    public S subscribe(@Nonnull QueryHandlerName var1, @Nonnull QueryHandler var2);

    default public S subscribe(@Nonnull QueryHandlingComponent handlingComponent) {
        return this.subscribe(handlingComponent.supportedQueries(), (QueryHandler)handlingComponent);
    }
}

