/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.reactivestreams.Publisher;
import reactor.util.concurrent.Queues;

public interface QueryGateway
extends DescribableComponent {
    @Nonnull
    public <R> CompletableFuture<R> query(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    public <R> Publisher<R> streamingQuery(@Nonnull Object var1, @Nonnull Class<R> var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, responseType, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    default public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.subscriptionQuery(query, responseType, m -> m.payloadAs(responseType), context, updateBufferSize);
    }

    @Nonnull
    default public <T> Publisher<T> subscriptionQuery(@Nonnull Object query, @Nonnull Class<T> responseType, @Nonnull Function<QueryResponseMessage, T> mapper, @Nullable ProcessingContext context) {
        return this.subscriptionQuery(query, responseType, mapper, context, Queues.SMALL_BUFFER_SIZE);
    }

    @Nonnull
    public <T> Publisher<T> subscriptionQuery(@Nonnull Object var1, @Nonnull Class<T> var2, @Nonnull Function<QueryResponseMessage, T> var3, @Nullable ProcessingContext var4, int var5);
}

