/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class MessageOriginProvider
implements CorrelationDataProvider {
    public static final String DEFAULT_CORRELATION_KEY = "correlationId";
    public static final String DEFAULT_CAUSATION_KEY = "causationId";
    private final String correlationKey;
    private final String causationKey;

    public MessageOriginProvider() {
        this(DEFAULT_CORRELATION_KEY, DEFAULT_CAUSATION_KEY);
    }

    public MessageOriginProvider(@Nonnull String correlationKey, @Nonnull String causationKey) {
        this.correlationKey = Objects.requireNonNull(correlationKey, "Correlation key must not be null.");
        this.causationKey = Objects.requireNonNull(causationKey, "Causation key must not be null.");
    }

    @Override
    @Nonnull
    public Map<String, String> correlationDataFor(@Nonnull Message message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.correlationKey, message.metadata().getOrDefault(this.correlationKey, message.identifier()));
        result.put(this.causationKey, message.identifier());
        return result;
    }
}

