/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class PayloadParameterResolver
implements ParameterResolver<Object> {
    private final Class<?> payloadType;

    public PayloadParameterResolver(Class<?> payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    public Object resolveParameterValue(@Nonnull ProcessingContext context) {
        return Message.fromContext(context).payload();
    }

    @Override
    public boolean matches(@Nonnull ProcessingContext context) {
        return Optional.ofNullable(Message.fromContext(context)).map(Message::payloadType).map(this.payloadType::isAssignableFrom).orElse(false);
    }

    @Override
    public Class<?> supportedPayloadType() {
        return this.payloadType;
    }
}

