/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class SingleValueMessageStream<M extends Message>
implements MessageStream.Single<M> {
    private final CompletableFuture<MessageStream.Entry<M>> source;
    private final AtomicBoolean read = new AtomicBoolean(false);

    SingleValueMessageStream(@Nullable MessageStream.Entry<M> entry) {
        this(CompletableFuture.completedFuture(entry));
    }

    SingleValueMessageStream(@Nonnull CompletableFuture<MessageStream.Entry<M>> source) {
        this.source = source;
    }

    @Override
    public CompletableFuture<MessageStream.Entry<M>> asCompletableFuture() {
        return this.source;
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        if (this.source.isDone() && !this.source.isCompletedExceptionally()) {
            MessageStream.Entry current = this.source.getNow(null);
            if (this.read.compareAndSet(false, true)) {
                return Optional.of(current);
            }
        }
        return Optional.empty();
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        if (this.source.isDone()) {
            callback.run();
        } else {
            this.source.whenComplete((T entry, U throwable) -> callback.run());
        }
    }

    @Override
    public Optional<Throwable> error() {
        return this.source.isCompletedExceptionally() ? Optional.of(this.source.exceptionNow()) : Optional.empty();
    }

    @Override
    public boolean isCompleted() {
        return this.source.isCompletedExceptionally() || this.read.get();
    }

    @Override
    public boolean hasNextAvailable() {
        return this.source.isDone() && !this.source.isCompletedExceptionally() && !this.read.get();
    }

    @Override
    public void close() {
        if (!this.source.isDone()) {
            this.source.cancel(false);
        }
    }

    @Override
    public <RM extends Message> MessageStream.Single<RM> map(@Nonnull Function<MessageStream.Entry<M>, MessageStream.Entry<RM>> mapper) {
        return new SingleValueMessageStream<M>(this.source.thenApply(mapper));
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<M>, R> accumulator) {
        return this.source.thenApply(message -> accumulator.apply(identity, (MessageStream.Entry)message));
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        if (this.source.isDone() && !this.source.isCompletedExceptionally() && !this.read.get()) {
            return Optional.ofNullable(this.source.getNow(null));
        }
        return Optional.empty();
    }
}

