/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.messaging.HierarchicalMessageTypeResolver;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;

public class NamespaceMessageTypeResolver
implements MessageTypeResolver {
    private final Map<Class<?>, MessageType> mappings;

    private NamespaceMessageTypeResolver(@Nonnull Map<Class<?>, MessageType> mappings) {
        Objects.requireNonNull(mappings, "Mappings may not be null.");
        this.mappings = mappings;
    }

    public static Builder namespace(@Nonnull String namespace) {
        Objects.requireNonNull(namespace, "Namespace may not be null.");
        return new Builder(namespace);
    }

    @Override
    public Optional<MessageType> resolve(@Nonnull Class<?> payloadType) {
        Objects.requireNonNull(payloadType, "Payload Type may not be null.");
        MessageType messageType = this.mappings.get(payloadType);
        return Optional.ofNullable(messageType);
    }

    public static class Builder {
        private String namespace;
        private final Map<Class<?>, MessageType> mappings = new HashMap();

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        public Builder namespace(@Nonnull String namespace) {
            Objects.requireNonNull(namespace, "Namespace may not be null.");
            this.namespace = namespace;
            return this;
        }

        public Builder message(@Nonnull Class<?> payloadType, @Nonnull String localName, @Nonnull String version) {
            Objects.requireNonNull(payloadType, "Payload Type may not be null.");
            Objects.requireNonNull(localName, "Local Name may not be null.");
            Objects.requireNonNull(version, "Version may not be null.");
            if (this.mappings.containsKey(payloadType)) {
                throw new IllegalArgumentException("A MessageType is already defined for payload type [" + payloadType.getName() + "]");
            }
            this.mappings.put(payloadType, new MessageType(this.namespace, localName, version));
            return this;
        }

        public MessageTypeResolver noFallback() {
            return new NamespaceMessageTypeResolver(this.mappings);
        }

        public MessageTypeResolver fallback(@Nonnull MessageTypeResolver resolver) {
            Objects.requireNonNull(resolver, "Message Type Resolver may not be null.");
            if (this.mappings.isEmpty()) {
                return resolver;
            }
            return new HierarchicalMessageTypeResolver(this.noFallback(), resolver);
        }
    }
}

