/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.messaging.CloseCallbackMessageStream;
import org.axonframework.messaging.CompletionCallbackMessageStream;
import org.axonframework.messaging.ConcatenatingMessageStream;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.EmptyMessageStream;
import org.axonframework.messaging.FailedMessageStream;
import org.axonframework.messaging.FilteringMessageStream;
import org.axonframework.messaging.IgnoredEntriesMessageStream;
import org.axonframework.messaging.IteratorMessageStream;
import org.axonframework.messaging.MappedMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStreamUtils;
import org.axonframework.messaging.OnErrorContinueMessageStream;
import org.axonframework.messaging.OnNextMessageStream;
import org.axonframework.messaging.SimpleEntry;
import org.axonframework.messaging.SingleValueMessageStream;
import org.axonframework.messaging.TruncateFirstMessageStream;

public interface MessageStream<M extends Message> {
    public static <M extends Message> MessageStream<M> fromIterable(@Nonnull Iterable<M> iterable) {
        return MessageStream.fromIterable(iterable, message -> Context.empty());
    }

    @SafeVarargs
    public static <M extends Message> MessageStream<M> fromItems(M ... items) {
        return MessageStream.fromIterable(List.of(items), message -> Context.empty());
    }

    public static <M extends Message> MessageStream<M> fromIterable(@Nonnull Iterable<M> iterable, @Nonnull Function<M, Context> contextSupplier) {
        return new IteratorMessageStream(StreamSupport.stream(iterable.spliterator(), false).map((? super T message) -> new SimpleEntry<Message>((Message)message, (Context)contextSupplier.apply(message))).iterator());
    }

    public static <M extends Message> MessageStream<M> fromStream(@Nonnull Stream<M> stream) {
        return MessageStream.fromStream(stream, message -> Context.empty());
    }

    public static <M extends Message> MessageStream<M> fromStream(@Nonnull Stream<M> stream, @Nonnull Function<M, Context> contextSupplier) {
        return new IteratorMessageStream(stream.map((? super T m) -> new SimpleEntry<Message>((Message)m, (Context)contextSupplier.apply(m))).iterator());
    }

    public static <T, M extends Message> MessageStream<M> fromStream(@Nonnull Stream<T> stream, @Nonnull Function<T, M> messageSupplier, @Nonnull Function<T, Context> contextSupplier) {
        return new IteratorMessageStream(stream.map((? super T item) -> new SimpleEntry<Message>((Message)messageSupplier.apply(item), (Context)contextSupplier.apply(item))).iterator());
    }

    public static <M extends Message> Single<M> fromFuture(@Nonnull CompletableFuture<M> future) {
        return MessageStream.fromFuture(future, message -> Context.empty());
    }

    public static <M extends Message> Single<M> fromFuture(@Nonnull CompletableFuture<M> future, @Nonnull Function<M, Context> contextSupplier) {
        return new SingleValueMessageStream(future.thenApply(message -> new SimpleEntry<Message>((Message)message, (Context)contextSupplier.apply(message))));
    }

    public static <M extends Message> Single<M> just(@Nullable M message) {
        return MessageStream.just(message, m -> Context.empty());
    }

    public static <M extends Message> Single<M> just(@Nullable M message, @Nonnull Function<M, Context> contextSupplier) {
        return new SingleValueMessageStream<M>(new SimpleEntry<M>(message, contextSupplier.apply(message)));
    }

    public static <M extends Message> Empty<M> failed(@Nonnull Throwable failure) {
        return new FailedMessageStream(failure);
    }

    public static Empty<Message> empty() {
        return EmptyMessageStream.instance();
    }

    default public Single<M> first() {
        return new TruncateFirstMessageStream(this);
    }

    default public Empty<M> ignoreEntries() {
        return new IgnoredEntriesMessageStream(this).cast();
    }

    public Optional<Entry<M>> next();

    public Optional<Entry<M>> peek();

    public void onAvailable(@Nonnull Runnable var1);

    public Optional<Throwable> error();

    public boolean isCompleted();

    public boolean hasNextAvailable();

    public void close();

    default public <RM extends Message> MessageStream<RM> map(@Nonnull Function<Entry<M>, Entry<RM>> mapper) {
        return new MappedMessageStream(this, mapper);
    }

    default public <RM extends Message> MessageStream<RM> mapMessage(@Nonnull Function<M, RM> mapper) {
        return this.map(entry -> entry.map(mapper));
    }

    default public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, Entry<M>, R> accumulator) {
        return MessageStreamUtils.reduce(this, identity, accumulator);
    }

    default public MessageStream<M> onNext(@Nonnull Consumer<Entry<M>> onNext) {
        return new OnNextMessageStream<M>(this, onNext);
    }

    default public MessageStream<M> onErrorContinue(@Nonnull Function<Throwable, MessageStream<M>> onError) {
        return new OnErrorContinueMessageStream<M>(this, onError);
    }

    default public MessageStream<M> filter(@Nonnull Predicate<Entry<M>> filter) {
        return new FilteringMessageStream<M>(this, filter);
    }

    default public MessageStream<M> concatWith(@Nonnull MessageStream<M> other) {
        return new ConcatenatingMessageStream<M>(this, other);
    }

    default public MessageStream<M> whenComplete(@Nonnull Runnable completeHandler) {
        return new CompletionCallbackMessageStream(this, completeHandler);
    }

    default public <T extends Message> MessageStream<T> cast() {
        return this;
    }

    default public MessageStream<M> onClose(Runnable closeHandler) {
        return new CloseCallbackMessageStream(this, closeHandler);
    }

    public static interface Single<M extends Message>
    extends MessageStream<M> {
        @Override
        default public Single<M> first() {
            return this;
        }

        @Override
        default public <RM extends Message> Single<RM> map(@Nonnull Function<Entry<M>, Entry<RM>> mapper) {
            return new MappedMessageStream.Single(this, mapper);
        }

        @Override
        default public <RM extends Message> Single<RM> mapMessage(@Nonnull Function<M, RM> mapper) {
            return this.map((T e) -> e.map(mapper));
        }

        @Override
        default public Single<M> filter(@Nonnull Predicate<Entry<M>> filter) {
            return new FilteringMessageStream.Single<M>(this, filter);
        }

        @Override
        default public Single<M> onNext(@Nonnull Consumer<Entry<M>> onNext) {
            return new OnNextMessageStream.Single<M>(this, onNext);
        }

        @Override
        default public Single<M> whenComplete(@Nonnull Runnable completeHandler) {
            return new CompletionCallbackMessageStream.Single(this, completeHandler);
        }

        @Override
        default public <R extends Message> Single<R> cast() {
            return this;
        }

        default public CompletableFuture<Entry<M>> asCompletableFuture() {
            return MessageStreamUtils.asCompletableFuture(this);
        }
    }

    public static interface Entry<M extends Message>
    extends Context {
        public M message();

        public <RM extends Message> Entry<RM> map(@Nonnull Function<M, RM> var1);

        @Override
        public <T> Entry<M> withResource(@Nonnull Context.ResourceKey<T> var1, @Nonnull T var2);
    }

    public static interface Empty<M extends Message>
    extends Single<M> {
        @Override
        default public Empty<M> first() {
            return this;
        }

        @Override
        default public <RM extends Message> Empty<RM> map(@Nonnull Function<Entry<M>, Entry<RM>> mapper) {
            return this.cast();
        }

        @Override
        default public <RM extends Message> Empty<RM> mapMessage(@Nonnull Function<M, RM> mapper) {
            return this.cast();
        }

        @Override
        default public Empty<M> onNext(@Nonnull Consumer<Entry<M>> onNext) {
            return this;
        }

        @Override
        default public MessageStream<M> concatWith(@Nonnull MessageStream<M> other) {
            return other;
        }

        @Override
        default public Empty<M> whenComplete(@Nonnull Runnable completeHandler) {
            return new CompletionCallbackMessageStream.Empty(this, completeHandler);
        }

        @Override
        default public <T extends Message> Empty<T> cast() {
            return this;
        }
    }
}

