/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class FailedMessageStream<M extends Message>
implements MessageStream.Empty<M> {
    private final Throwable error;

    FailedMessageStream(@Nonnull Throwable error) {
        this.error = error;
    }

    @Override
    public CompletableFuture<MessageStream.Entry<M>> asCompletableFuture() {
        return CompletableFuture.failedFuture(this.error);
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        return Optional.empty();
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        callback.run();
    }

    @Override
    public Optional<Throwable> error() {
        return Optional.of(this.error);
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public boolean hasNextAvailable() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public <RM extends Message> MessageStream.Empty<RM> map(@Nonnull Function<MessageStream.Entry<M>, MessageStream.Entry<RM>> mapper) {
        return this;
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<M>, R> accumulator) {
        return CompletableFuture.failedFuture(this.error);
    }

    @Override
    public MessageStream.Empty<M> whenComplete(@Nonnull Runnable completeHandler) {
        return this;
    }

    @Override
    public MessageStream<M> concatWith(@Nonnull MessageStream<M> other) {
        return this;
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        return Optional.empty();
    }
}

