/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.streaming.token.store;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.eventhandling.processors.streaming.segmenting.Segment;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface TokenStore {
    @Nonnull
    public CompletableFuture<List<Segment>> initializeTokenSegments(@Nonnull String var1, int var2, @Nullable TrackingToken var3, @Nullable ProcessingContext var4);

    @Nonnull
    public CompletableFuture<Void> storeToken(@Nullable TrackingToken var1, @Nonnull String var2, int var3, @Nullable ProcessingContext var4);

    @Nonnull
    public CompletableFuture<TrackingToken> fetchToken(@Nonnull String var1, int var2, @Nullable ProcessingContext var3);

    @Nonnull
    default public CompletableFuture<TrackingToken> fetchToken(@Nonnull String processorName, @Nonnull Segment segment, @Nullable ProcessingContext context) {
        return this.fetchToken(processorName, segment.getSegmentId(), context);
    }

    @Nonnull
    default public CompletableFuture<Void> extendClaim(@Nonnull String processorName, int segmentId, @Nullable ProcessingContext context) {
        return this.fetchToken(processorName, segmentId, context).thenRun(() -> {});
    }

    @Nonnull
    public CompletableFuture<Void> releaseClaim(@Nonnull String var1, int var2, @Nullable ProcessingContext var3);

    @Nonnull
    public CompletableFuture<Void> initializeSegment(@Nullable TrackingToken var1, @Nonnull String var2, @Nonnull Segment var3, @Nullable ProcessingContext var4);

    @Nonnull
    public CompletableFuture<Void> deleteToken(@Nonnull String var1, int var2, @Nullable ProcessingContext var3);

    @Nonnull
    public CompletableFuture<Segment> fetchSegment(@Nonnull String var1, int var2, @Nullable ProcessingContext var3);

    @Nonnull
    public CompletableFuture<List<Segment>> fetchSegments(@Nonnull String var1, @Nullable ProcessingContext var2);

    @Nonnull
    public CompletableFuture<List<Segment>> fetchAvailableSegments(@Nonnull String var1, @Nullable ProcessingContext var2);

    @Nonnull
    public CompletableFuture<String> retrieveStorageIdentifier(@Nullable ProcessingContext var1);
}

