/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.processors.errorhandling;

import jakarta.annotation.Nonnull;
import org.axonframework.eventhandling.processors.EventProcessingException;
import org.axonframework.eventhandling.processors.errorhandling.ErrorContext;
import org.axonframework.eventhandling.processors.errorhandling.ErrorHandler;

public enum PropagatingErrorHandler implements ErrorHandler
{
    INSTANCE;


    public static PropagatingErrorHandler instance() {
        return INSTANCE;
    }

    @Override
    public void handleError(@Nonnull ErrorContext errorContext) throws Exception {
        Throwable error = errorContext.error();
        if (error instanceof Error) {
            throw (Error)error;
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new EventProcessingException("An error occurred while handling an event.", error);
    }
}

