/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.annotations.Internal;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.serialization.CachingSupplier;
import org.axonframework.serialization.Converter;

public class GenericEventMessage
extends MessageDecorator
implements EventMessage {
    private final Supplier<Instant> timestampSupplier;
    @Internal
    @Deprecated
    public static Clock clock = Clock.systemUTC();

    public GenericEventMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(type, payload, Metadata.emptyInstance());
    }

    public GenericEventMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metadata) {
        this((Message)new GenericMessage(type, payload, metadata), clock.instant());
    }

    public GenericEventMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metadata, @Nonnull Instant timestamp) {
        this((Message)new GenericMessage(identifier, type, payload, metadata), timestamp);
    }

    public GenericEventMessage(@Nonnull Message delegate, @Nonnull Supplier<Instant> timestampSupplier) {
        super(delegate);
        this.timestampSupplier = CachingSupplier.of(timestampSupplier);
    }

    protected GenericEventMessage(@Nonnull Message delegate, @Nonnull Instant timestamp) {
        this(delegate, CachingSupplier.of(timestamp));
    }

    @Override
    @Nonnull
    public Instant timestamp() {
        return this.timestampSupplier.get();
    }

    @Override
    @Nonnull
    public EventMessage withMetadata(@Nonnull Map<String, String> metadata) {
        if (this.metadata().equals(metadata)) {
            return this;
        }
        return new GenericEventMessage(this.delegate().withMetadata(metadata), this.timestampSupplier);
    }

    @Override
    @Nonnull
    public EventMessage andMetadata(@Nonnull Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty() || this.metadata().equals(metadata)) {
            return this;
        }
        return new GenericEventMessage(this.delegate().andMetadata(metadata), this.timestampSupplier);
    }

    @Override
    @Nonnull
    public EventMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return new GenericEventMessage((Message)converted, this.timestamp());
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", timestamp='").append(this.timestamp());
    }

    @Override
    protected String describeType() {
        return "GenericEventMessage";
    }
}

