/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.DelegatingCommandBusConnector;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public class PayloadConvertingCommandBusConnector
extends DelegatingCommandBusConnector {
    private final MessageConverter converter;
    private final Class<?> targetType;

    public PayloadConvertingCommandBusConnector(@Nonnull CommandBusConnector delegate, @Nonnull MessageConverter converter, @Nonnull Class<?> targetType) {
        super(delegate);
        this.converter = Objects.requireNonNull(converter, "The converter must not be null.");
        this.targetType = Objects.requireNonNull(targetType, "The targetType must not be null.");
    }

    @Override
    @Nonnull
    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        return this.delegate.dispatch((CommandMessage)command.withConvertedPayload((Class)this.targetType, (Converter)this.converter), processingContext);
    }

    @Override
    public void onIncomingCommand(@Nonnull CommandBusConnector.Handler handler) {
        this.delegate.onIncomingCommand((commandMessage, callback) -> handler.handle(commandMessage, new ConvertingResultMessageCallback(callback)));
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("converter", this.converter);
        descriptor.describeProperty("targetType", this.targetType);
    }

    private class ConvertingResultMessageCallback
    implements CommandBusConnector.ResultCallback {
        private final CommandBusConnector.ResultCallback callback;

        private ConvertingResultMessageCallback(CommandBusConnector.ResultCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess(CommandResultMessage resultMessage) {
            if (resultMessage == null || resultMessage.payload() == null) {
                this.callback.onSuccess(resultMessage);
                return;
            }
            this.callback.onSuccess((CommandResultMessage)resultMessage.withConvertedPayload((Class)PayloadConvertingCommandBusConnector.this.targetType, (Converter)PayloadConvertingCommandBusConnector.this.converter));
        }

        @Override
        public void onError(@Nonnull Throwable cause) {
            this.callback.onError(cause);
        }
    }
}

