/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotations;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.SimpleCommandHandlingComponent;
import org.axonframework.commandhandling.annotations.CommandHandlingMember;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotations.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotations.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotations.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotations.HandlerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.interceptors.annotations.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public class AnnotatedCommandHandlingComponent<T>
implements CommandHandlingComponent {
    private final SimpleCommandHandlingComponent handlingComponent;
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final MessageTypeResolver messageTypeResolver;
    private final MessageConverter converter;

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull MessageConverter converter) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()), converter);
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageConverter converter) {
        this(annotatedCommandHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedCommandHandler.getClass()), new ClassBasedMessageTypeResolver(), converter);
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter converter) {
        this.handlingComponent = SimpleCommandHandlingComponent.create("AnnotatedCommandHandlingComponent[%s]".formatted(annotatedCommandHandler.getClass().getName()));
        this.target = Objects.requireNonNull(annotatedCommandHandler, "The Annotated Command Handler may not be null.");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedCommandHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver may not be null.");
        this.converter = Objects.requireNonNull(converter, "The Converter may not be null.");
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(h -> h.canHandleMessageType(CommandMessage.class)).forEach(this::registerHandler));
    }

    private void registerHandler(MessageHandlingMember<? super T> handler) {
        Class<?> payloadType = handler.payloadType();
        QualifiedName qualifiedName = handler.unwrap(CommandHandlingMember.class).map(CommandHandlingMember::commandName).filter(name -> !name.equals(payloadType.getName())).map(QualifiedName::new).orElseGet(() -> this.messageTypeResolver.resolve(payloadType).orElse(new MessageType(payloadType)).qualifiedName());
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        this.handlingComponent.subscribe(qualifiedName, (command, ctx) -> interceptorChain.handle(command.withConvertedPayload((Class)payloadType, (Converter)this.converter), ctx, this.target, handler).mapMessage(this::asCommandResultMessage).first().cast());
    }

    private CommandResultMessage asCommandResultMessage(@Nonnull Message commandResult) {
        return commandResult instanceof CommandResultMessage ? (CommandResultMessage)commandResult : new GenericCommandResultMessage(commandResult);
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext processingContext) {
        return this.handlingComponent.handle(command, processingContext);
    }

    @Override
    public Set<QualifiedName> supportedCommands() {
        return Set.copyOf(this.handlingComponent.supportedCommands());
    }
}

