/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.messaging.QualifiedName;

public interface CommandHandlerRegistry<S extends CommandHandlerRegistry<S>> {
    public S subscribe(@Nonnull QualifiedName var1, @Nonnull CommandHandler var2);

    default public S subscribe(@Nonnull Set<QualifiedName> names, @Nonnull CommandHandler commandHandler) {
        Objects.requireNonNull(names, "The set of names may not be null");
        Objects.requireNonNull(commandHandler, "The commandHandler may not be null");
        names.forEach(name -> this.subscribe((QualifiedName)name, commandHandler));
        return (S)this;
    }

    default public S subscribe(@Nonnull CommandHandlingComponent handlingComponent) {
        return this.subscribe(handlingComponent.supportedCommands(), (CommandHandler)handlingComponent);
    }
}

