/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.ConversionException;

public class ByteArrayToJsonNodeConverter
implements ContentTypeConverter<byte[], JsonNode> {
    private final ObjectMapper objectMapper;

    public ByteArrayToJsonNodeConverter(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "The ObjectMapper may not be null.");
    }

    @Override
    @Nonnull
    public Class<byte[]> expectedSourceType() {
        return byte[].class;
    }

    @Override
    @Nonnull
    public Class<JsonNode> targetType() {
        return JsonNode.class;
    }

    @Override
    @Nullable
    public JsonNode convert(@Nullable byte[] input) {
        if (input == null) {
            return null;
        }
        try {
            return this.objectMapper.readTree(input);
        }
        catch (IOException e) {
            throw new ConversionException("An error occurred while converting a JsonNode to byte[].", e);
        }
    }
}

