/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.util.ClassUtils;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;
import org.axonframework.serialization.avro.AvroSerializerStrategy;
import org.axonframework.serialization.avro.AvroSerializerStrategyConfig;
import org.axonframework.serialization.avro.ByteArrayToGenericRecordConverter;
import org.axonframework.serialization.avro.DefaultSchemaIncompatibilityChecker;
import org.axonframework.serialization.avro.SchemaIncompatibilityChecker;
import org.axonframework.serialization.avro.SpecificRecordBaseSerializerStrategy;

@Deprecated(forRemoval=true, since="5.0.0")
public class AvroSerializer
implements Serializer {
    private final RevisionResolver revisionResolver;
    private final Converter converter;
    private final List<AvroSerializerStrategy> serializerStrategies = new ArrayList<AvroSerializerStrategy>();
    private final Serializer serializerDelegate;

    protected AvroSerializer(@Nonnull Builder builder) {
        builder.validate();
        this.revisionResolver = builder.revisionResolver;
        this.serializerDelegate = builder.serializerDelegate;
        this.serializerStrategies.addAll(builder.serializerStrategies);
        Converter converter = this.converter = builder.converter;
        if (converter instanceof ChainingContentTypeConverter) {
            ChainingContentTypeConverter chainingConverter = (ChainingContentTypeConverter)converter;
            chainingConverter.registerConverter(new ByteArrayToGenericRecordConverter(builder.schemaStore));
            Converter delegateConverter = this.serializerDelegate.getConverter();
            if (delegateConverter instanceof ChainingContentTypeConverter) {
                chainingConverter.setAdditionalConverters(((ChainingContentTypeConverter)delegateConverter).getContentTypeConverters());
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, @Nonnull Class<T> expectedRepresentation) {
        Optional<AvroSerializerStrategy> serializerStrategy;
        if (object != null && (serializerStrategy = this.serializerStrategies.stream().filter(it -> it.test(object.getClass())).findFirst()).isPresent() && byte[].class.equals(expectedRepresentation)) {
            return serializerStrategy.get().serializeToSingleObjectEncoded(object);
        }
        return this.serializerDelegate.serialize(object, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(@Nonnull SerializedObject<S> serializedObject) {
        if (SerializedType.isEmptyType(serializedObject.getType())) {
            return null;
        }
        Class payloadType = this.classForType(serializedObject.getType());
        if (UnknownSerializedType.class.isAssignableFrom(payloadType)) {
            return (T)new UnknownSerializedType(this, serializedObject);
        }
        Optional<AvroSerializerStrategy> serializerStrategy = this.serializerStrategies.stream().filter(it -> it.test(payloadType)).findFirst();
        if (serializerStrategy.isPresent()) {
            if (serializedObject.getContentType().equals(GenericRecord.class)) {
                return serializerStrategy.get().deserializeFromGenericRecord(serializedObject, payloadType);
            }
            SerializedObject<Object> bytesSerialized = serializedObject.getContentType().equals(byte[].class) ? serializedObject : new SimpleSerializedObject<byte[]>(this.convert((Object)serializedObject.getData(), byte[].class), byte[].class, serializedObject.getType());
            return serializerStrategy.get().deserializeFromSingleObjectEncoded(bytesSerialized, payloadType);
        }
        return this.serializerDelegate.deserialize(serializedObject);
    }

    @Override
    public <T> boolean canSerializeTo(@Nonnull Class<T> expectedRepresentation) {
        return GenericRecord.class.equals(expectedRepresentation) || this.getConverter().canConvert(byte[].class, expectedRepresentation) || this.serializerDelegate.canSerializeTo(expectedRepresentation);
    }

    @Override
    public Class classForType(@Nonnull SerializedType type) {
        if (SimpleSerializedType.emptyType().equals(type)) {
            return Void.class;
        }
        try {
            return ClassUtils.forName((String)this.resolveClassName(type));
        }
        catch (ClassNotFoundException e) {
            return UnknownSerializedType.class;
        }
    }

    protected String resolveClassName(SerializedType serializedType) {
        return serializedType.getName();
    }

    @Override
    public SerializedType typeForClass(@Nullable Class type) {
        if (type == null || Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return SimpleSerializedType.emptyType();
        }
        return new SimpleSerializedType(type.getName(), this.revisionResolver.revisionOf(type));
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    public static class Builder {
        private final List<AvroSerializerStrategy> serializerStrategies = new ArrayList<AvroSerializerStrategy>();
        private final AvroSerializerStrategyConfig.Builder configurationBuilder = AvroSerializerStrategyConfig.builder();
        private RevisionResolver revisionResolver = new AnnotationRevisionResolver();
        private SchemaStore schemaStore;
        private SchemaIncompatibilityChecker schemaIncompatibilityChecker = new DefaultSchemaIncompatibilityChecker();
        private Serializer serializerDelegate;
        private Converter converter = new ChainingContentTypeConverter();
        private boolean includeDefaultStrategies = true;

        public Builder revisionResolver(@Nonnull RevisionResolver revisionResolver) {
            BuilderUtils.assertNonNull(revisionResolver, "RevisionResolver may not be null");
            this.revisionResolver = revisionResolver;
            return this;
        }

        public Builder schemaStore(@Nonnull SchemaStore schemaStore) {
            BuilderUtils.assertNonNull(schemaStore, "SchemaStore may not be null");
            this.schemaStore = schemaStore;
            return this;
        }

        public Builder schemaIncompatibilityChecker(@Nonnull SchemaIncompatibilityChecker incompatibilityChecker) {
            BuilderUtils.assertNonNull(incompatibilityChecker, "SchemaIncompatibilityChecker may not be null");
            this.schemaIncompatibilityChecker = incompatibilityChecker;
            return this;
        }

        public Builder serializerDelegate(@Nonnull Serializer serializerDelegate) {
            BuilderUtils.assertNonNull(serializerDelegate, "Serializer delegate may not be null");
            this.serializerDelegate = serializerDelegate;
            return this;
        }

        public Builder addSerializerStrategy(@Nonnull AvroSerializerStrategy strategy) {
            BuilderUtils.assertNonNull(strategy, "AvroSerializerStrategy may not be null");
            this.serializerStrategies.add(strategy);
            return this;
        }

        public Builder converter(Converter converter) {
            BuilderUtils.assertNonNull(converter, "Converter may not be null");
            this.converter = converter;
            return this;
        }

        public Builder includeDefaultAvroSerializationStrategies(boolean includeDefaultStrategies) {
            this.includeDefaultStrategies = includeDefaultStrategies;
            return this;
        }

        public Builder performSchemaCompatibilityCheck(boolean performSchemaCompatibilityCheck) {
            this.configurationBuilder.performAvroCompatibilityCheck(performSchemaCompatibilityCheck);
            return this;
        }

        public Builder includeSchemasInStackTraces(boolean includeSchemasInStackTraces) {
            this.configurationBuilder.includeSchemasInStackTraces(includeSchemasInStackTraces);
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.revisionResolver, "RevisionResolver is mandatory");
            BuilderUtils.assertNonNull(this.schemaStore, "SchemaStore is mandatory");
            BuilderUtils.assertNonNull(this.serializerDelegate, "SerializerDelegate is mandatory");
            BuilderUtils.assertNonNull(this.schemaIncompatibilityChecker, "SchemaIncompatibilityChecker is mandatory");
            BuilderUtils.assertThat(this.serializerStrategies, strategies -> !strategies.isEmpty(), "At least one AvroSerializerStrategy must be provided.");
        }

        public AvroSerializer build() {
            if (this.includeDefaultStrategies) {
                SpecificRecordBaseSerializerStrategy defaultStrategy = new SpecificRecordBaseSerializerStrategy(this.schemaStore, this.revisionResolver, this.schemaIncompatibilityChecker);
                this.addSerializerStrategy(defaultStrategy);
            }
            AvroSerializerStrategyConfig configuration = this.configurationBuilder.build();
            this.serializerStrategies.forEach(strategy -> strategy.applyConfig(configuration));
            return new AvroSerializer(this);
        }
    }
}

