/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

@Deprecated(forRemoval=true, since="5.0.0")
public class LazyDeserializingObject<T> {
    private final transient Serializer serializer;
    private final Supplier<SerializedObject<?>> serializedObject;
    private final Class<T> deserializedObjectType;
    private volatile transient T deserializedObject;

    public LazyDeserializingObject(T deserializedObject) {
        Assert.notNull(deserializedObject, () -> "The given deserialized instance may not be null");
        this.serializedObject = null;
        this.serializer = null;
        this.deserializedObject = deserializedObject;
        this.deserializedObjectType = deserializedObject.getClass();
    }

    public LazyDeserializingObject(SerializedObject<?> serializedObject, Serializer serializer) {
        this(() -> serializedObject, serializedObject.getType(), serializer);
    }

    public LazyDeserializingObject(Supplier<SerializedObject<?>> serializedObjectSupplier, SerializedType serializedType, Serializer serializer) {
        Assert.notNull(serializedObjectSupplier, () -> "The given serializedObjectSupplier may not be null");
        Assert.notNull(serializedType, () -> "The given serializedType may not be null");
        Assert.notNull(serializer, () -> "The given serializer may not be null");
        this.serializedObject = serializedObjectSupplier;
        this.serializer = serializer;
        this.deserializedObjectType = serializer.classForType(serializedType);
    }

    public Class<T> getType() {
        return this.deserializedObjectType;
    }

    public T getObject() {
        if (!this.isDeserialized()) {
            this.deserializedObject = this.serializer.deserialize(this.serializedObject.get());
        }
        return this.deserializedObject;
    }

    public boolean isDeserialized() {
        return this.deserializedObject != null;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public SerializedObject<?> getSerializedObject() {
        return this.serializedObject.get();
    }
}

