/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandlerAdapter;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.annotation.QueryHandlingMember;

public class AnnotationQueryHandlerAdapter<T>
implements QueryHandlerAdapter,
MessageHandler<QueryMessage, QueryResponseMessage> {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;

    public AnnotationQueryHandlerAdapter(T target) {
        this(target, ClasspathParameterResolverFactory.forClass(target.getClass()));
    }

    public AnnotationQueryHandlerAdapter(T target, ParameterResolverFactory parameterResolverFactory) {
        this(target, parameterResolverFactory, ClasspathHandlerDefinition.forClass(target.getClass()));
    }

    public AnnotationQueryHandlerAdapter(T target, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.model = AnnotatedHandlerInspector.inspectType(target.getClass(), parameterResolverFactory, handlerDefinition);
        this.target = target;
    }

    @Override
    public Registration subscribe(@Nonnull QueryBus queryBus) {
        Collection registrations = this.model.getHandlers(this.target.getClass()).map(handler -> handler.unwrap(QueryHandlingMember.class)).filter(Optional::isPresent).map(Optional::get).map(queryHandler -> queryBus.subscribe(queryHandler.getQueryName(), queryHandler.getResultType(), this)).collect(Collectors.toList());
        return () -> registrations.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public Object handleSync(@Nonnull QueryMessage message, @Nonnull ProcessingContext context) throws Exception {
        MessageHandlingMember handler = this.model.getHandlers(this.target.getClass()).filter(m -> m.canHandle(message, context)).findFirst().orElseThrow(() -> new NoHandlerForQueryException(message));
        return this.model.chainedInterceptor(this.target.getClass()).handleSync(message, context, this.target, handler);
    }

    @Override
    public boolean canHandle(@Nonnull QueryMessage message, @Nonnull ProcessingContext context) {
        return this.model.getHandlers(this.target.getClass()).anyMatch(handlingMember -> handlingMember.canHandle(message, context));
    }
}

