/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public interface QueryBus {
    public Registration subscribe(@Nonnull String var1, @Nonnull Type var2, @Nonnull MessageHandler<? super QueryMessage, ? extends QueryResponseMessage> var3);

    public CompletableFuture<QueryResponseMessage> query(@Nonnull QueryMessage var1);

    default public Publisher<QueryResponseMessage> streamingQuery(StreamingQueryMessage query) {
        throw new UnsupportedOperationException("Streaming query is not supported by this QueryBus.");
    }

    public Stream<QueryResponseMessage> scatterGather(@Nonnull QueryMessage var1, long var2, @Nonnull TimeUnit var4);

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage, SubscriptionQueryUpdateMessage> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query) {
        return this.subscriptionQuery(query, Queues.SMALL_BUFFER_SIZE);
    }

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage, SubscriptionQueryUpdateMessage> subscriptionQuery(final @Nonnull SubscriptionQueryMessage<Q, I, U> query, int updateBufferSize) {
        return new SubscriptionQueryResult<QueryResponseMessage, SubscriptionQueryUpdateMessage>(){

            @Override
            public Mono<QueryResponseMessage> initialResult() {
                return Mono.fromFuture(() -> QueryBus.this.query(query));
            }

            @Override
            public Flux<SubscriptionQueryUpdateMessage> updates() {
                return Flux.empty();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
    }

    public QueryUpdateEmitter queryUpdateEmitter();
}

