/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryBusSpanFactory;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultQueryBusSpanFactory
implements QueryBusSpanFactory {
    private final SpanFactory spanFactory;
    private final boolean distributedInSameTrace;

    protected DefaultQueryBusSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.distributedInSameTrace = builder.distributedInSameTrace;
    }

    @Override
    public Span createQuerySpan(QueryMessage queryMessage, boolean distributed) {
        if (distributed) {
            return this.spanFactory.createDispatchSpan(() -> "QueryBus.queryDistributed", queryMessage, new Message[0]);
        }
        return this.spanFactory.createInternalSpan(() -> "QueryBus.query", queryMessage);
    }

    @Override
    public Span createSubscriptionQuerySpan(SubscriptionQueryMessage<?, ?, ?> queryMessage, boolean distributed) {
        if (distributed) {
            return this.spanFactory.createDispatchSpan(() -> "QueryBus.subscriptionQueryDistributed", queryMessage, new Message[0]);
        }
        return this.spanFactory.createInternalSpan(() -> "QueryBus.subscriptionQuery", queryMessage);
    }

    @Override
    public Span createSubscriptionQueryProcessUpdateSpan(SubscriptionQueryUpdateMessage updateMessage, SubscriptionQueryMessage<?, ?, ?> queryMessage) {
        return this.spanFactory.createChildHandlerSpan(() -> "QueryBus.queryUpdate", updateMessage, queryMessage);
    }

    @Override
    public Span createScatterGatherSpan(QueryMessage queryMessage, boolean distributed) {
        if (distributed) {
            return this.spanFactory.createDispatchSpan(() -> "QueryBus.scatterGatherQueryDistributed", queryMessage, new Message[0]);
        }
        return this.spanFactory.createInternalSpan(() -> "QueryBus.scatterGatherQuery", queryMessage);
    }

    @Override
    public Span createScatterGatherHandlerSpan(QueryMessage queryMessage, int handlerIndex) {
        return this.spanFactory.createInternalSpan(() -> "QueryBus.scatterGatherHandler-" + handlerIndex, queryMessage);
    }

    @Override
    public Span createStreamingQuerySpan(QueryMessage queryMessage, boolean distributed) {
        if (distributed) {
            return this.spanFactory.createDispatchSpan(() -> "QueryBus.streamingQueryDistributed", queryMessage, new Message[0]);
        }
        return this.spanFactory.createChildHandlerSpan(() -> "QueryBus.streamingQuery", queryMessage, new Message[0]);
    }

    @Override
    public Span createQueryProcessingSpan(QueryMessage queryMessage) {
        if (this.distributedInSameTrace) {
            return this.spanFactory.createChildHandlerSpan(() -> "QueryBus.processQueryMessage", queryMessage, new Message[0]);
        }
        return this.spanFactory.createLinkedHandlerSpan(() -> "QueryBus.processQueryMessage", queryMessage, new Message[0]);
    }

    @Override
    public Span createResponseProcessingSpan(QueryMessage queryMessage) {
        return this.spanFactory.createInternalSpan(() -> "QueryBus.processQueryResponse", queryMessage);
    }

    @Override
    public <M extends QueryMessage> M propagateContext(M queryMessage) {
        return this.spanFactory.propagateContext(queryMessage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean distributedInSameTrace = true;
        private SpanFactory builderSpanFactory;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder distributedInSameTrace(boolean distributedInSameTrace) {
            this.distributedInSameTrace = distributedInSameTrace;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.builderSpanFactory, "spanFactory may not be null");
        }

        public DefaultQueryBusSpanFactory build() {
            return new DefaultQueryBusSpanFactory(this);
        }
    }
}

