/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import jakarta.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.timeout.HandlerTimeoutConfiguration;
import org.axonframework.messaging.timeout.TaskTimeoutSettings;
import org.axonframework.messaging.timeout.TimeoutWrappedMessageHandlingMember;
import org.axonframework.queryhandling.QueryMessage;

public class HandlerTimeoutHandlerEnhancerDefinition
implements HandlerEnhancerDefinition {
    private final HandlerTimeoutConfiguration configuration;

    public HandlerTimeoutHandlerEnhancerDefinition(HandlerTimeoutConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        TaskTimeoutSettings config = this.getConfigurationForMember(original);
        if (config == null) {
            return original;
        }
        int timeout = this.getAttribute(original, "timeoutMs", config.getTimeoutMs());
        int warning = this.getAttribute(original, "warningThresholdMs", config.getWarningThresholdMs());
        int warningInterval = this.getAttribute(original, "warningIntervalMs", config.getWarningIntervalMs());
        if (timeout < 0 && warning < 0) {
            return original;
        }
        return new TimeoutWrappedMessageHandlingMember<T>(original, timeout, warning, warningInterval);
    }

    private int getAttribute(MessageHandlingMember<?> original, String name, int fallback) {
        return (Integer)original.attribute("MessageHandlerTimeout." + name).filter(i -> (Integer)i >= 0).orElse(fallback);
    }

    private TaskTimeoutSettings getConfigurationForMember(@Nonnull MessageHandlingMember<?> original) {
        if (original.canHandleMessageType(EventMessage.class)) {
            return this.configuration.getEvents();
        }
        if (original.canHandleMessageType(CommandMessage.class)) {
            return this.configuration.getCommands();
        }
        if (original.canHandleMessageType(QueryMessage.class)) {
            return this.configuration.getQueries();
        }
        if (original.canHandleMessageType(DeadlineMessage.class)) {
            return this.configuration.getDeadlines();
        }
        return null;
    }
}

