/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.util.Objects;
import org.axonframework.common.AxonException;
import org.axonframework.messaging.deadletter.Cause;

public class ThrowableCause
extends AxonException
implements Cause {
    public static final int TRUNCATED_MESSAGE_SIZE = 1023;
    private final String type;
    private final String message;

    public ThrowableCause(Throwable throwable) {
        super(throwable.getMessage(), throwable);
        this.type = throwable.getClass().getName();
        this.message = throwable.getMessage();
    }

    public ThrowableCause(String type, String message) {
        super(message);
        this.type = type;
        this.message = message;
    }

    public static ThrowableCause asCause(Throwable cause) {
        return cause instanceof ThrowableCause ? (ThrowableCause)cause : new ThrowableCause(cause);
    }

    public static ThrowableCause truncated(Throwable throwable) {
        return ThrowableCause.truncated(throwable, 1023);
    }

    public static ThrowableCause truncated(Throwable throwable, int messageSize) {
        return new ThrowableCause(throwable.getClass().getName(), throwable.getMessage() == null ? null : throwable.getMessage().substring(0, Math.min(throwable.getMessage().length(), messageSize)));
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String message() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrowableCause that = (ThrowableCause)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message);
    }

    @Override
    public String toString() {
        return "Cause{type=[" + this.type + "]-message=[" + this.message + "]}";
    }
}

