/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import jakarta.annotation.Nonnull;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;

public interface SequencedDeadLetterQueue<M extends Message> {
    public void enqueue(@Nonnull Object var1, @Nonnull DeadLetter<? extends M> var2) throws DeadLetterQueueOverflowException;

    default public boolean enqueueIfPresent(@Nonnull Object sequenceIdentifier, @Nonnull Supplier<DeadLetter<? extends M>> letterBuilder) throws DeadLetterQueueOverflowException {
        if (!this.contains(sequenceIdentifier)) {
            return false;
        }
        this.enqueue(sequenceIdentifier, letterBuilder.get());
        return true;
    }

    public void evict(DeadLetter<? extends M> var1);

    public void requeue(@Nonnull DeadLetter<? extends M> var1, @Nonnull UnaryOperator<DeadLetter<? extends M>> var2) throws NoSuchDeadLetterException;

    public boolean contains(@Nonnull Object var1);

    public Iterable<DeadLetter<? extends M>> deadLetterSequence(@Nonnull Object var1);

    public Iterable<Iterable<DeadLetter<? extends M>>> deadLetters();

    public boolean isFull(@Nonnull Object var1);

    public long size();

    public long sequenceSize(@Nonnull Object var1);

    public long amountOfSequences();

    public boolean process(@Nonnull Predicate<DeadLetter<? extends M>> var1, @Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> var2);

    default public boolean process(@Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        return this.process(letter -> true, processingTask);
    }

    public void clear();
}

